/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.sql.hikari.pool;

import io.lumine.mythic.lib.sql.hikari.pool.HikariProxyCallableStatement;
import io.lumine.mythic.lib.sql.hikari.pool.HikariProxyConnection;
import io.lumine.mythic.lib.sql.hikari.pool.HikariProxyDatabaseMetaData;
import io.lumine.mythic.lib.sql.hikari.pool.HikariProxyPreparedStatement;
import io.lumine.mythic.lib.sql.hikari.pool.HikariProxyResultSet;
import io.lumine.mythic.lib.sql.hikari.pool.HikariProxyStatement;
import io.lumine.mythic.lib.sql.hikari.pool.PoolEntry;
import io.lumine.mythic.lib.sql.hikari.pool.ProxyConnection;
import io.lumine.mythic.lib.sql.hikari.pool.ProxyLeakTask;
import io.lumine.mythic.lib.sql.hikari.pool.ProxyStatement;
import io.lumine.mythic.lib.sql.hikari.util.FastList;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public final class ProxyFactory {
    private ProxyFactory() {
    }

    static ProxyConnection getProxyConnection(PoolEntry poolEntry, Connection connection, FastList<Statement> fastList, ProxyLeakTask proxyLeakTask, long l, boolean bl, boolean bl2) {
        return new HikariProxyConnection(poolEntry, connection, (FastList)fastList, proxyLeakTask, l, bl, bl2);
    }

    static Statement getProxyStatement(ProxyConnection proxyConnection, Statement statement) {
        return new HikariProxyStatement(proxyConnection, statement);
    }

    static CallableStatement getProxyCallableStatement(ProxyConnection proxyConnection, CallableStatement callableStatement) {
        return new HikariProxyCallableStatement(proxyConnection, callableStatement);
    }

    static PreparedStatement getProxyPreparedStatement(ProxyConnection proxyConnection, PreparedStatement preparedStatement) {
        return new HikariProxyPreparedStatement(proxyConnection, preparedStatement);
    }

    static ResultSet getProxyResultSet(ProxyConnection proxyConnection, ProxyStatement proxyStatement, ResultSet resultSet) {
        return new HikariProxyResultSet(proxyConnection, proxyStatement, resultSet);
    }

    static DatabaseMetaData getProxyDatabaseMetaData(ProxyConnection proxyConnection, DatabaseMetaData databaseMetaData) {
        return new HikariProxyDatabaseMetaData(proxyConnection, databaseMetaData);
    }
}

