/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationUpdater {
    private final Path configurationFile;
    private final String defaultConfigurationFile;
    private final ClassLoader loader;

    public ConfigurationUpdater(Path configurationFile, String defaultConfigurationFile, ClassLoader loader) {
        this.configurationFile = configurationFile;
        this.defaultConfigurationFile = defaultConfigurationFile;
        this.loader = loader;
    }

    public void update() {
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)this.configurationFile.toFile());
        try (InputStream inputStream = this.loader.getResourceAsStream(this.defaultConfigurationFile);){
            if (inputStream == null) {
                throw new RuntimeException("Could not find default configuration file: " + this.defaultConfigurationFile);
            }
            boolean changed = false;
            try (InputStreamReader reader = new InputStreamReader(inputStream);){
                YamlConfiguration defaultConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
                for (String key : defaultConfiguration.getKeys(true)) {
                    if (configuration.contains(key)) continue;
                    configuration.set(key, defaultConfiguration.get(key));
                    changed = true;
                }
            }
            if (changed) {
                configuration.save(this.configurationFile.toFile());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

