/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util;

import io.lumine.mythic.lib.MythicLib;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ParabolicProjectile
extends BukkitRunnable {
    private final Location target;
    private final Consumer<Location> display;
    private final Vector vec;
    private final Runnable end;
    private final int speed;
    private final Location loc;
    private int j;

    public ParabolicProjectile(Location source, Location target, Color color) {
        this(source, target, Particle.REDSTONE, () -> {}, 1, color, 1.0f);
    }

    public ParabolicProjectile(Location source, Location target, Particle particle, Runnable end, int speed, Color color, float size) {
        this(source, target, target.clone().subtract(source).toVector().multiply(0.1).setY(6).normalize().multiply(0.3), end, speed, (Location loc) -> loc.getWorld().spawnParticle(particle, loc, 1, (Object)new Particle.DustOptions(color, size)));
    }

    public ParabolicProjectile(Location source, Location target, Runnable end, Color color) {
        this(source, target, target.clone().subtract(source).toVector().multiply(0.1).setY(6).normalize().multiply(0.3), end, 1, (Location loc) -> loc.getWorld().spawnParticle(Particle.REDSTONE, loc, 1, (Object)new Particle.DustOptions(color, 1.0f)));
    }

    public ParabolicProjectile(Location source, Location target, Particle particle) {
        this(source, target, target.clone().subtract(source).toVector().multiply(0.1).setY(6).normalize().multiply(0.3), () -> {}, 1, (Location loc) -> loc.getWorld().spawnParticle(particle, loc, 0));
    }

    public ParabolicProjectile(Location source, Location target, Runnable end, int speed, Particle particle) {
        this(source, target, target.clone().subtract(source).toVector().multiply(0.1).setY(6).normalize().multiply(0.3), end, speed, (Location loc) -> loc.getWorld().spawnParticle(particle, loc, 0));
    }

    public ParabolicProjectile(Location source, Location target, Vector vec, Runnable end, int speed, Particle particle) {
        this(source, target, vec, end, speed, (Location loc) -> loc.getWorld().spawnParticle(particle, loc, 0));
    }

    private ParabolicProjectile(Location source, Location target, Vector vec, Runnable end, int speed, Consumer<Location> display) {
        this.loc = source.clone();
        this.target = target;
        this.display = display;
        this.end = end;
        this.vec = vec;
        this.speed = Math.max(1, speed);
        this.runTaskTimer((Plugin)MythicLib.plugin, 0L, 1L);
    }

    public void run() {
        for (int k = 0; k < this.speed; ++k) {
            if (this.j++ > 100 || this.loc.distanceSquared(this.target) < 0.8) {
                this.end.run();
                this.cancel();
            }
            double c = Math.min(1.0, (double)this.j / 40.0);
            this.display.accept(this.loc.add(this.target.clone().subtract(this.loc).toVector().normalize().multiply(c).add(this.vec.clone().multiply(1.0 - c))));
        }
    }
}

