/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util.configobject;

import io.lumine.mythic.lib.util.DoubleFormula;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.Validate;

public interface ConfigObject {
    public String getString(String var1);

    public String getString(String var1, String var2);

    public double getDouble(String var1);

    public double getDouble(String var1, double var2);

    public int getInt(String var1);

    public int getInt(String var1, int var2);

    public boolean getBoolean(String var1);

    public boolean getBoolean(String var1, boolean var2);

    default public DoubleFormula getDoubleFormula(String key) {
        return new DoubleFormula(this.getString(key));
    }

    default public DoubleFormula getDoubleFormula(String key, DoubleFormula defaultValue) {
        return this.contains(key) ? this.getDoubleFormula(key) : Objects.requireNonNull(defaultValue, "Default value cannot be null");
    }

    public ConfigObject getObject(String var1);

    public boolean contains(String var1);

    public Set<String> getKeys();

    default public void validateKeys(String ... keys) {
        for (String key : keys) {
            Validate.isTrue((boolean)this.contains(key), (String)("Could not find key '" + key + "' in config"));
        }
    }

    default public void validateArgs(int count) {
        Validate.isTrue((this.getKeys().size() >= count ? 1 : 0) != 0, (String)("Config must have at least " + count + " parameters"));
    }
}

