/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.util.loadingorder;

import io.lumine.mythic.lib.util.loadingorder.DependencyCycleCheck;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.plugin.Plugin;

public class DependencyNode {
    public final String name;
    public final int id;
    public final Map<Integer, DependencyNode> children = new HashMap<Integer, DependencyNode>();
    public Plugin plugin;

    public DependencyNode(int id, Plugin plugin) {
        this.id = id;
        this.name = plugin.getName();
        this.plugin = plugin;
    }

    public void loadAdjacency(DependencyCycleCheck checker) {
        DependencyNode found;
        Validate.notNull((Object)this.plugin, (String)"Already loaded");
        ArrayList deps = new ArrayList(this.plugin.getDescription().getDepend());
        deps.addAll(this.plugin.getDescription().getSoftDepend());
        for (String name : deps) {
            found = checker.registry.get(name);
            if (found == null) continue;
            this.children.put(found.id, found);
        }
        for (String name : this.plugin.getDescription().getLoadBefore()) {
            found = checker.registry.get(name);
            if (found == null || found.children.containsKey(this.id)) continue;
            found.children.put(this.id, this);
        }
        this.plugin = null;
    }

    public String toString() {
        return this.name;
    }
}

