/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.version;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.version.ServerVersion;
import java.util.function.Predicate;

public enum SoundServerVersion {
    V1_16(version -> version.isStrictlyHigher(1, 15), 1),
    V1_13(version -> version.isStrictlyHigher(1, 12) && version.isBelowOrEqual(1, 15), 0),
    LEGACY(version -> version.isBelowOrEqual(1, 12), 2);

    private final Predicate<ServerVersion> matches;
    private final int index;
    public static final SoundServerVersion FOUND;

    private SoundServerVersion(Predicate<ServerVersion> matches, int index) {
        this.matches = matches;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean matches(ServerVersion version) {
        return this.matches.test(version);
    }

    private static SoundServerVersion findVersion() {
        ServerVersion server = MythicLib.plugin.getVersion();
        for (SoundServerVersion checked : SoundServerVersion.values()) {
            if (!checked.matches(server)) continue;
            return checked;
        }
        return V1_16;
    }

    static {
        FOUND = SoundServerVersion.findVersion();
    }
}

