/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.lib.version.wrapper;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTCompound;
import io.lumine.mythic.lib.api.item.NBTItem;
import io.lumine.mythic.lib.api.util.NBTTypeHelper;
import io.lumine.mythic.lib.version.wrapper.VersionWrapper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.ChatMessage;
import net.minecraft.server.v1_16_R2.ChatMessageType;
import net.minecraft.server.v1_16_R2.Container;
import net.minecraft.server.v1_16_R2.ContainerAccess;
import net.minecraft.server.v1_16_R2.ContainerAnvil;
import net.minecraft.server.v1_16_R2.Containers;
import net.minecraft.server.v1_16_R2.EntityHuman;
import net.minecraft.server.v1_16_R2.EntityPlayer;
import net.minecraft.server.v1_16_R2.EnumHand;
import net.minecraft.server.v1_16_R2.IChatBaseComponent;
import net.minecraft.server.v1_16_R2.ICrafting;
import net.minecraft.server.v1_16_R2.ItemStack;
import net.minecraft.server.v1_16_R2.MinecraftKey;
import net.minecraft.server.v1_16_R2.NBTBase;
import net.minecraft.server.v1_16_R2.NBTTagCompound;
import net.minecraft.server.v1_16_R2.NBTTagList;
import net.minecraft.server.v1_16_R2.NBTTagString;
import net.minecraft.server.v1_16_R2.Packet;
import net.minecraft.server.v1_16_R2.PacketPlayInArmAnimation;
import net.minecraft.server.v1_16_R2.PacketPlayOutAnimation;
import net.minecraft.server.v1_16_R2.PacketPlayOutChat;
import net.minecraft.server.v1_16_R2.PacketPlayOutCloseWindow;
import net.minecraft.server.v1_16_R2.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_16_R2.PlayerConnection;
import net.minecraft.server.v1_16_R2.SoundEffect;
import net.minecraft.server.v1_16_R2.SoundEffectType;
import net.minecraft.server.v1_16_R2.TileEntitySkull;
import net.minecraft.server.v1_16_R2.World;
import net.minecraft.server.v1_16_R2.WorldServer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.craftbukkit.libs.org.apache.commons.lang3.reflect.FieldUtils;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class VersionWrapper_1_16_R2
implements VersionWrapper {
    private final Map<Material, Material> oreDrops = new HashMap<Material, Material>();
    private final Set<Material> generatorOutputs = new HashSet<Material>();

    public VersionWrapper_1_16_R2() {
        this.oreDrops.put(Material.IRON_ORE, Material.IRON_INGOT);
        this.oreDrops.put(Material.GOLD_ORE, Material.GOLD_INGOT);
        this.oreDrops.put(Material.ANCIENT_DEBRIS, Material.NETHERITE_SCRAP);
        this.generatorOutputs.add(Material.COBBLESTONE);
        this.generatorOutputs.add(Material.OBSIDIAN);
        this.generatorOutputs.add(Material.BASALT);
    }

    @Override
    public boolean isGeneratorOutput(Material material) {
        return this.generatorOutputs.contains(material);
    }

    @Override
    public Map<Material, Material> getOreDrops() {
        return this.oreDrops;
    }

    @Override
    public float getAttackCooldown(Player player) {
        return player.getAttackCooldown();
    }

    @Override
    public int getFoodRestored(org.bukkit.inventory.ItemStack item) {
        return CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item).getItem().getFoodInfo().getNutrition();
    }

    @Override
    public float getSaturationRestored(org.bukkit.inventory.ItemStack item) {
        return CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item).getItem().getFoodInfo().getSaturationModifier();
    }

    @Override
    public void sendJson(Player player, String message) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutChat((IChatBaseComponent)IChatBaseComponent.ChatSerializer.a((String)message), ChatMessageType.CHAT, UUID.randomUUID()));
    }

    @Override
    public void sendActionBarRaw(Player player, String message) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutChat((IChatBaseComponent)IChatBaseComponent.ChatSerializer.a((String)message), ChatMessageType.GAME_INFO, UUID.randomUUID()));
    }

    @Override
    public int getNextContainerId(Player player) {
        return this.toNMS(player).nextContainerCounter();
    }

    @Override
    public void handleInventoryCloseEvent(Player player) {
        CraftEventFactory.handleInventoryCloseEvent((EntityHuman)this.toNMS(player));
    }

    @Override
    public void sendPacketOpenWindow(Player player, int containerId) {
        this.toNMS((Player)player).playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(containerId, Containers.ANVIL, (IChatBaseComponent)new ChatMessage("Repair & Name")));
    }

    @Override
    public void sendPacketCloseWindow(Player player, int containerId) {
        this.toNMS((Player)player).playerConnection.sendPacket((Packet)new PacketPlayOutCloseWindow(containerId));
    }

    @Override
    public void setActiveContainerDefault(Player player) {
        this.toNMS((Player)player).activeContainer = this.toNMS((Player)player).defaultContainer;
    }

    @Override
    public void setActiveContainer(Player player, Object container) {
        this.toNMS((Player)player).activeContainer = (Container)container;
    }

    @Override
    public void setActiveContainerId(Object container, int containerId) {
        Field field = null;
        try {
            field = Container.class.getField("windowId");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        FieldUtils.removeFinalModifier((Field)field);
        try {
            FieldUtils.writeField((Field)field, (Object)container, (Object)containerId);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addActiveContainerSlotListener(Object container, Player player) {
        ((Container)container).addSlotListener((ICrafting)this.toNMS(player));
    }

    @Override
    public Inventory toBukkitInventory(Object container) {
        return ((Container)container).getBukkitView().getTopInventory();
    }

    @Override
    public Object newContainerAnvil(Player player) {
        return new AnvilContainer(player);
    }

    private EntityPlayer toNMS(Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    @Override
    public NBTItem getNBTItem(org.bukkit.inventory.ItemStack item) {
        return new NBTItem_v1_16_R2(item);
    }

    @Override
    public void playArmAnimation(Player player) {
        EntityPlayer p = ((CraftPlayer)player).getHandle();
        PlayerConnection connection = p.playerConnection;
        PacketPlayOutAnimation armSwing = new PacketPlayOutAnimation((net.minecraft.server.v1_16_R2.Entity)p, 0);
        connection.sendPacket((Packet)armSwing);
        connection.a(new PacketPlayInArmAnimation(EnumHand.MAIN_HAND));
    }

    @Override
    public Sound getBlockPlaceSound(Block block) {
        try {
            WorldServer nmsWorld = ((CraftWorld)block.getWorld()).getHandle();
            net.minecraft.server.v1_16_R2.Block nmsBlock = nmsWorld.getType(new BlockPosition(block.getX(), block.getY(), block.getZ())).getBlock();
            SoundEffectType soundEffectType = nmsBlock.getStepSound(nmsBlock.getBlockData());
            Field breakSound = SoundEffectType.class.getDeclaredField("Z");
            breakSound.setAccessible(true);
            SoundEffect nmsSound = (SoundEffect)breakSound.get(soundEffectType);
            Field keyField = SoundEffect.class.getDeclaredField("b");
            keyField.setAccessible(true);
            MinecraftKey nmsString = (MinecraftKey)keyField.get(nmsSound);
            return Sound.valueOf((String)nmsString.getKey().replace(".", "_").toUpperCase());
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String getSkullValue(Block block) {
        TileEntitySkull skullTile = (TileEntitySkull)((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (skullTile.gameProfile == null) {
            return "";
        }
        return ((Property)skullTile.gameProfile.getProperties().get((Object)"textures").iterator().next()).getValue();
    }

    @Override
    public void setSkullValue(Block block, String value) {
        TileEntitySkull skullTile = (TileEntitySkull)((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", value));
        skullTile.setGameProfile(profile);
        skullTile.update();
    }

    @Override
    public FurnaceRecipe getFurnaceRecipe(String path, org.bukkit.inventory.ItemStack item, Material material, float exp, int cook) {
        return new FurnaceRecipe(new NamespacedKey((Plugin)MythicLib.inst(), "mmoitems_furnace_" + path), item, material, exp, cook);
    }

    @Override
    public NBTItem copyTexture(NBTItem item) {
        return this.getNBTItem(new org.bukkit.inventory.ItemStack(item.getItem().getType())).addTag(new ItemTag("CustomModelData", item.getInteger("CustomModelData")));
    }

    @Override
    public org.bukkit.inventory.ItemStack textureItem(Material material, int model) {
        return this.getNBTItem(new org.bukkit.inventory.ItemStack(material)).addTag(new ItemTag("CustomModelData", model)).toItem();
    }

    @Override
    public Enchantment getEnchantmentFromString(String s) {
        return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)s));
    }

    @Override
    public FurnaceRecipe getFurnaceRecipe(NamespacedKey key, org.bukkit.inventory.ItemStack item, Material material, float exp, int cook) {
        return new FurnaceRecipe(key, item, material, exp, cook);
    }

    @Override
    public boolean isCropFullyGrown(Block block) {
        if (block.getBlockData() instanceof Ageable) {
            Ageable ageable = (Ageable)block.getBlockData();
            return ageable.getAge() == ageable.getMaximumAge();
        }
        return false;
    }

    @Override
    public boolean isUndead(Entity entity) {
        EntityType type = entity.getType();
        return type == EntityType.SKELETON || type == EntityType.STRAY || type == EntityType.WITHER_SKELETON || type == EntityType.ZOMBIE || type == EntityType.DROWNED || type == EntityType.HUSK || type.name().equals("PIG_ZOMBIE") || type == EntityType.ZOMBIE_VILLAGER || type == EntityType.PHANTOM || type == EntityType.WITHER || type == EntityType.SKELETON_HORSE || type == EntityType.ZOMBIE_HORSE;
    }

    private class AnvilContainer
    extends ContainerAnvil {
        public AnvilContainer(Player player) {
            super(VersionWrapper_1_16_R2.this.getNextContainerId(player), ((CraftPlayer)player).getHandle().inventory, ContainerAccess.at((World)((CraftWorld)player.getWorld()).getHandle(), (BlockPosition)new BlockPosition(0, 0, 0)));
            this.checkReachable = false;
            this.setTitle((IChatBaseComponent)new ChatMessage("Repair & Name"));
        }
    }

    public static class NBTItem_v1_16_R2
    extends NBTItem {
        private final ItemStack nms;
        private final NBTTagCompound compound;

        public NBTItem_v1_16_R2(org.bukkit.inventory.ItemStack item) {
            super(item);
            this.nms = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item);
            this.compound = this.nms.hasTag() ? this.nms.getTag() : new NBTTagCompound();
        }

        @Override
        public Object get(String path) {
            return this.compound.get(path);
        }

        @Override
        public String getString(String path) {
            return this.compound.getString(path);
        }

        @Override
        public boolean hasTag(String path) {
            return this.compound.hasKey(path);
        }

        @Override
        public boolean getBoolean(String path) {
            return this.compound.getBoolean(path);
        }

        @Override
        public double getDouble(String path) {
            return this.compound.getDouble(path);
        }

        @Override
        public int getInteger(String path) {
            return this.compound.getInt(path);
        }

        @Override
        public NBTCompound getNBTCompound(String path) {
            return new NBTCompound_v1_16_R2(this, path);
        }

        @Override
        public NBTItem addTag(List<ItemTag> tags) {
            tags.forEach(tag -> {
                if (tag.getValue() instanceof Boolean) {
                    this.compound.setBoolean(tag.getPath(), ((Boolean)tag.getValue()).booleanValue());
                } else if (tag.getValue() instanceof Double) {
                    this.compound.setDouble(tag.getPath(), ((Double)tag.getValue()).doubleValue());
                } else if (tag.getValue() instanceof String) {
                    this.compound.setString(tag.getPath(), (String)tag.getValue());
                } else if (tag.getValue() instanceof Integer) {
                    this.compound.setInt(tag.getPath(), ((Integer)tag.getValue()).intValue());
                } else if (tag.getValue() instanceof List) {
                    NBTTagList tagList = new NBTTagList();
                    for (Object s : (List)tag.getValue()) {
                        if (!(s instanceof String)) continue;
                        tagList.add((Object)NBTTagString.a((String)((String)s)));
                    }
                    this.compound.set(tag.getPath(), (NBTBase)tagList);
                }
            });
            return this;
        }

        @Override
        public NBTItem removeTag(String ... paths) {
            for (String path : paths) {
                this.compound.remove(path);
            }
            return this;
        }

        @Override
        public Set<String> getTags() {
            return this.compound.getKeys();
        }

        @Override
        public org.bukkit.inventory.ItemStack toItem() {
            this.nms.setTag(this.compound);
            return CraftItemStack.asBukkitCopy((ItemStack)this.nms);
        }

        @Override
        public int getTypeId(String path) {
            return this.compound.get(path).getTypeId();
        }
    }

    private static class NBTCompound_v1_16_R2
    extends NBTCompound {
        private final NBTTagCompound compound;

        public NBTCompound_v1_16_R2(NBTItem_v1_16_R2 item, String path) {
            this.compound = item.hasTag(path) && NBTTypeHelper.COMPOUND.is(item.getTypeId(path)) ? item.compound.getCompound(path) : new NBTTagCompound();
        }

        public NBTCompound_v1_16_R2(NBTCompound_v1_16_R2 comp, String path) {
            this.compound = comp.hasTag(path) && NBTTypeHelper.COMPOUND.is(comp.getTypeId(path)) ? comp.compound.getCompound(path) : new NBTTagCompound();
        }

        @Override
        public boolean hasTag(String path) {
            return this.compound.hasKey(path);
        }

        @Override
        public Object get(String path) {
            return this.compound.get(path);
        }

        @Override
        public NBTCompound getNBTCompound(String path) {
            return new NBTCompound_v1_16_R2(this, path);
        }

        @Override
        public String getString(String path) {
            return this.compound.getString(path);
        }

        @Override
        public boolean getBoolean(String path) {
            return this.compound.getBoolean(path);
        }

        @Override
        public double getDouble(String path) {
            return this.compound.getDouble(path);
        }

        @Override
        public int getInteger(String path) {
            return this.compound.getInt(path);
        }

        @Override
        public Set<String> getTags() {
            return this.compound.getKeys();
        }

        @Override
        public int getTypeId(String path) {
            return this.compound.get(path).getTypeId();
        }
    }
}

