/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;

public enum AbstractDirection {
    DOWN("down", Axis.Y, AxisDirection.NEGATIVE, 1, new AbstractVector(0, -1, 0)),
    UP("up", Axis.Y, AxisDirection.POSITIVE, 0, new AbstractVector(0, 1, 0)),
    NORTH("north", Axis.Z, AxisDirection.NEGATIVE, 3, new AbstractVector(0, 0, -1)),
    SOUTH("south", Axis.Z, AxisDirection.POSITIVE, 2, new AbstractVector(0, 0, 1)),
    WEST("west", Axis.X, AxisDirection.NEGATIVE, 5, new AbstractVector(-1, 0, 0)),
    EAST("east", Axis.X, AxisDirection.POSITIVE, 4, new AbstractVector(1, 0, 0));

    private final String name;
    private final Axis axis;
    private final AxisDirection axisDirection;
    private final int oppositeDirectionIndex;
    private final AbstractVector normalization;

    public double getStepX() {
        return this.normalization.getX();
    }

    public double getStepY() {
        return this.normalization.getY();
    }

    public double getStepZ() {
        return this.normalization.getZ();
    }

    public static AbstractDirection getRelative(AbstractLocation from, AbstractLocation to) {
        int dx = to.getBlockX() - from.getBlockX();
        int dy = to.getBlockY() - from.getBlockY();
        int dz = to.getBlockZ() - from.getBlockZ();
        if (Math.abs(dx) > Math.abs(dy) && Math.abs(dx) > Math.abs(dz)) {
            if (dx > 0) {
                return EAST;
            }
            return WEST;
        }
        if (Math.abs(dy) > Math.abs(dx) && Math.abs(dy) > Math.abs(dz)) {
            if (dy > 0) {
                return UP;
            }
            return DOWN;
        }
        if (dz > 0) {
            return SOUTH;
        }
        return NORTH;
    }

    private AbstractDirection(String name, Axis axis, AxisDirection axisDirection, int oppositeDirectionIndex, AbstractVector normalization) {
        this.name = name;
        this.axis = axis;
        this.axisDirection = axisDirection;
        this.oppositeDirectionIndex = oppositeDirectionIndex;
        this.normalization = normalization;
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }

    public static enum AxisDirection {
        POSITIVE,
        NEGATIVE;

    }
}

