/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BukkitBee
extends BukkitEntityType {
    private static final int height = 1;
    private AgeableProperty ageableProperty;
    private int anger = 0;
    private boolean hasNectar = false;
    private boolean hasStung = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.anger = mc.getInteger("Options.Anger", 0);
        this.hasNectar = mc.getBoolean("Options.HasNectar", false);
        this.hasStung = mc.getBoolean("Options.HasStung", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Entity e = this.spawnEntity(location, EntityType.BEE, reason, prespawnFunc);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Bee e = (Bee)entity;
        e.setAnger(this.anger);
        e.setHasNectar(this.hasNectar);
        e.setHasStung(this.hasStung);
        this.ageableProperty.applyProperties(entity);
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Bee;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

