/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Rabbit;

public class BukkitRabbit
extends BukkitEntityType {
    private static final int height = 1;
    private AgeableProperty ageableProperty;
    private boolean isAngry = false;
    private boolean isBaby = false;
    private Rabbit.Type type;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.isAngry = mc.getBoolean("Options.IsKillerBunny", false);
        this.isAngry = mc.getBoolean("Options.Angry", this.isAngry);
        this.isBaby = mc.getBoolean("Options.Baby", false);
        String t2 = mc.getString("Options.RabbitType", null);
        if (t2 != null) {
            this.type = Rabbit.Type.valueOf((String)t2.toUpperCase());
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason, Consumer<Entity> prespawnFunc) {
        Entity e = this.spawnEntity(location, EntityType.RABBIT, reason, prespawnFunc);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Rabbit e = (Rabbit)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.isBaby) {
            e.setBaby();
        }
        if (this.type != null) {
            e.setRabbitType(this.type);
        }
        if (this.isAngry) {
            e.setRabbitType(Rabbit.Type.THE_KILLER_BUNNY);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Rabbit;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

