/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.ConfigurationSection;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.config.properties.types.BooleanProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.IntProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.LangListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.LangProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.MaterialProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemProp
extends PropertyType<ItemStack> {
    private ItemStack def;
    private MaterialProp MATERIAL;
    private IntProp AMOUNT;
    private LangProp DISPLAY;
    private LangListProp LORE;
    private IntProp MODEL;
    private BooleanProp HIDE_FLAGS;
    private StringProp COLOR;
    private StringProp SKULL_OWNER;
    private StringProp SKULL_TEXTURE;

    public ItemProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, (String)node);
        node = node == null || ((String)node).isEmpty() ? "" : (String)node + ".";
        this.MATERIAL = new MaterialProp(plugin, file, (String)node + "Material", Material.AIR);
        this.AMOUNT = new IntProp(plugin, file, (String)node + "Amount", 1);
        this.DISPLAY = new LangProp(plugin, file, (String)node + "Display", " ");
        this.LORE = new LangListProp(plugin, file, (String)node + "Lore");
        this.MODEL = new IntProp(plugin, file, (String)node + "Model", 0);
        this.HIDE_FLAGS = new BooleanProp(plugin, file, (String)node + "HideFlags", false);
        this.COLOR = new StringProp(plugin, file, (String)node + "Color", null);
        this.SKULL_OWNER = new StringProp(plugin, file, (String)node + "SkullOwner", null);
        this.SKULL_TEXTURE = new StringProp(plugin, file, (String)node + "SkullTexture", null);
        this.def = new ItemStack(Material.STONE);
    }

    public ItemProp(LuminePlugin plugin, Object file, String node, ItemStack def) {
        super(plugin, file, node);
        this.def = def;
    }

    @Override
    protected ItemStack compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.def;
        }
        if (!section.isConfigurationSection(node)) {
            try {
                String str = section.getString(node);
                Material mat = Material.valueOf((String)str.toUpperCase());
                return new ItemStack(mat);
            }
            catch (Throwable ex) {
                return new ItemStack(Material.STONE);
            }
        }
        Material material = (Material)this.MATERIAL.get(section);
        if (material == Material.AIR) {
            return this.def;
        }
        int amount = (Integer)this.AMOUNT.get(section);
        String display = (String)this.DISPLAY.get(section);
        List lore = (List)this.LORE.get(section);
        int model = (Integer)this.MODEL.get(section);
        boolean hideFlags = (Boolean)this.HIDE_FLAGS.get(section);
        String color = (String)this.COLOR.get(section);
        String skullOwner = (String)this.SKULL_OWNER.get(section);
        String skullTexture = (String)this.SKULL_TEXTURE.get(section);
        ItemFactory factory = ItemFactory.of(material).name(display).lore(lore).amount(amount).model(model);
        if (color != null) {
            factory.color(color);
        }
        if (hideFlags) {
            factory.hideAttributes();
        }
        if (skullOwner != null) {
            factory.skullOwner(skullOwner);
        }
        if (skullTexture != null) {
            factory.skullTexture(skullTexture);
        }
        return factory.build();
    }

    @Override
    public void set(String holder, ItemStack value) {
        if (this.config == null) {
            return;
        }
    }
}

