/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.Field;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function2;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractField;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Names;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SQLDataType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;

final class ArrayGet<T>
extends AbstractField<T>
implements QOM.ArrayGet<T> {
    final Field<T[]> array;
    final Field<Integer> index;

    ArrayGet(Field<T[]> array, Field<Integer> index) {
        super(Names.N_ARRAY_GET, Tools.allNotNull(StringUtils.defaultIfNull(array.getDataType().getArrayComponentDataType(), SQLDataType.OTHER), array, index));
        this.array = Tools.nullSafeNotNull(array, SQLDataType.OTHER.getArrayDataType());
        this.index = Tools.nullSafeNotNull(index, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case HSQLDB: {
                ctx.visit(DSL.when(DSL.cardinality(this.array).ge(this.index), new Standard()));
                break;
            }
            default: {
                ctx.visit(new Standard());
            }
        }
    }

    @Override
    public final Field<T[]> $array() {
        return this.array;
    }

    @Override
    public final Field<Integer> $index() {
        return this.index;
    }

    @Override
    public final QOM.ArrayGet<T> $array(Field<T[]> newValue) {
        return this.constructor().apply(newValue, this.$index());
    }

    @Override
    public final QOM.ArrayGet<T> $index(Field<Integer> newValue) {
        return this.constructor().apply(this.$array(), newValue);
    }

    public final Function2<? super Field<T[]>, ? super Field<Integer>, ? extends QOM.ArrayGet<T>> constructor() {
        return (a1, a2) -> new ArrayGet((Field<T[]>)a1, (Field<Integer>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.ArrayGet) {
            QOM.ArrayGet o = (QOM.ArrayGet)that;
            return StringUtils.equals(this.$array(), o.$array()) && StringUtils.equals(this.$index(), o.$index());
        }
        return super.equals(that);
    }

    private class Standard
    extends AbstractField<T>
    implements QOM.UTransient {
        Standard() {
            super(ArrayGet.this.getQualifiedName(), ArrayGet.this.getDataType());
        }

        @Override
        public void accept(Context<?> ctx) {
            ctx.sql('(').visit(ArrayGet.this.array).sql(')').sql('[').visit(ArrayGet.this.index).sql(']');
        }
    }
}

