/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.ExecuteListener;
import io.lumine.mythic.bukkit.utils.lib.jooq.Query;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.SettingsTools;
import io.lumine.mythic.bukkit.utils.lib.jooq.exception.ControlFlowSignal;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractBatch;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DSL;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DefaultExecuteContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.ExecuteListeners;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.NoConnectionFactory;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.R2DBC;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SettingsEnabledPreparedStatement;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.r2dbc.spi.ConnectionFactory;
import java.sql.Connection;
import java.sql.SQLException;
import org.reactivestreams.Subscriber;

final class BatchMultiple
extends AbstractBatch {
    final Query[] queries;

    public BatchMultiple(Configuration configuration, Query ... queries) {
        super(configuration);
        this.queries = queries;
    }

    @Override
    public final int size() {
        return this.queries.length;
    }

    @Override
    public final void subscribe(Subscriber<? super Integer> subscriber) {
        ConnectionFactory cf = this.configuration.connectionFactory();
        if (cf instanceof NoConnectionFactory) {
            throw new UnsupportedOperationException();
        }
        subscriber.onSubscribe(new R2DBC.BatchSubscription<BatchMultiple>(this, subscriber, s2 -> new R2DBC.BatchMultipleSubscriber(this, (R2DBC.BatchSubscription<BatchMultiple>)s2)));
    }

    @Override
    public final int[] execute() {
        return BatchMultiple.execute(this.configuration, this.queries);
    }

    static int[] execute(Configuration configuration, Query[] queries) {
        DefaultExecuteContext ctx = new DefaultExecuteContext(configuration, queries);
        ExecuteListener listener = ExecuteListeners.get(ctx);
        Connection connection = ctx.connection();
        try {
            int i;
            listener.start(ctx);
            if (ctx.statement() == null) {
                ctx.statement(new SettingsEnabledPreparedStatement(connection));
            }
            String[] batchSQL = ctx.batchSQL();
            for (i = 0; i < queries.length; ++i) {
                ctx.sql(null);
                listener.renderStart(ctx);
                batchSQL[i] = DSL.using(configuration).renderInlined(queries[i]);
                ctx.sql(batchSQL[i]);
                listener.renderEnd(ctx);
            }
            for (i = 0; i < queries.length; ++i) {
                ctx.sql(batchSQL[i]);
                listener.prepareStart(ctx);
                ctx.statement().addBatch(batchSQL[i]);
                listener.prepareEnd(ctx);
            }
            int t2 = SettingsTools.getQueryTimeout(0, ctx.settings());
            if (t2 != 0) {
                ctx.statement().setQueryTimeout(t2);
            }
            listener.executeStart(ctx);
            int[] result = ctx.statement().executeBatch();
            int[] batchRows = ctx.batchRows();
            for (int i2 = 0; i2 < batchRows.length && i2 < result.length; ++i2) {
                batchRows[i2] = result[i2];
            }
            listener.executeEnd(ctx);
            int[] nArray = result;
            return nArray;
        }
        catch (ControlFlowSignal e) {
            throw e;
        }
        catch (RuntimeException e) {
            ctx.exception(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        catch (SQLException e) {
            ctx.sqlException(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        finally {
            Tools.safeClose(listener, ctx);
        }
    }
}

