/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Clause;
import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.Context;
import io.lumine.mythic.bukkit.utils.lib.jooq.DropSchemaFinalStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.DropSchemaStep;
import io.lumine.mythic.bukkit.utils.lib.jooq.Function3;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.Schema;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.AbstractDDLQuery;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.DDLStatementType;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Keywords;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.QOM;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Set;

final class DropSchemaImpl
extends AbstractDDLQuery
implements QOM.DropSchema,
DropSchemaStep,
DropSchemaFinalStep {
    final Schema schema;
    final boolean ifExists;
    QOM.Cascade cascade;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_SCHEMA};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> REQUIRES_RESTRICT = SQLDialect.supportedBy(SQLDialect.DERBY);

    DropSchemaImpl(Configuration configuration, Schema schema, boolean ifExists) {
        this(configuration, schema, ifExists, null);
    }

    DropSchemaImpl(Configuration configuration, Schema schema, boolean ifExists, QOM.Cascade cascade) {
        super(configuration);
        this.schema = schema;
        this.ifExists = ifExists;
        this.cascade = cascade;
    }

    @Override
    public final DropSchemaImpl cascade() {
        this.cascade = QOM.Cascade.CASCADE;
        return this;
    }

    @Override
    public final DropSchemaImpl restrict() {
        this.cascade = QOM.Cascade.RESTRICT;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        this.accept0(ctx);
    }

    private void accept0(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.DROP_SCHEMA, c -> this.accept1((Context<?>)c));
        } else {
            this.accept1(ctx);
        }
    }

    private void accept1(Context<?> ctx) {
        ctx.start(Clause.DROP_SCHEMA_SCHEMA).visit(Keywords.K_DROP);
        ctx.sql(' ').visit(Keywords.K_SCHEMA);
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.schema);
        if (this.cascade == QOM.Cascade.CASCADE) {
            ctx.sql(' ').visit(Keywords.K_CASCADE);
        } else if (this.cascade == QOM.Cascade.RESTRICT || REQUIRES_RESTRICT.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_RESTRICT);
        }
        ctx.end(Clause.DROP_SCHEMA_SCHEMA);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Schema $schema() {
        return this.schema;
    }

    @Override
    public final boolean $ifExists() {
        return this.ifExists;
    }

    @Override
    public final QOM.Cascade $cascade() {
        return this.cascade;
    }

    @Override
    public final QOM.DropSchema $schema(Schema newValue) {
        return this.constructor().apply(newValue, (Boolean)this.$ifExists(), this.$cascade());
    }

    @Override
    public final QOM.DropSchema $ifExists(boolean newValue) {
        return this.constructor().apply(this.$schema(), (Boolean)newValue, this.$cascade());
    }

    @Override
    public final QOM.DropSchema $cascade(QOM.Cascade newValue) {
        return this.constructor().apply(this.$schema(), (Boolean)this.$ifExists(), newValue);
    }

    public final Function3<? super Schema, ? super Boolean, ? super QOM.Cascade, ? extends QOM.DropSchema> constructor() {
        return (a1, a2, a3) -> new DropSchemaImpl(this.configuration(), (Schema)a1, (boolean)a2, (QOM.Cascade)((Object)a3));
    }
}

