/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.TransactionContext;
import io.lumine.mythic.bukkit.utils.lib.jooq.TransactionListener;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.InvocationOrder;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import java.util.Arrays;

class TransactionListeners
implements TransactionListener {
    private final TransactionListener[] listeners;

    TransactionListeners(Configuration configuration) {
        this.listeners = Tools.map(configuration.transactionListenerProviders(), p -> p.provide(), TransactionListener[]::new);
    }

    @Override
    public final void beginStart(TransactionContext ctx) {
        for (TransactionListener listener : ctx.settings().getTransactionListenerStartInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(this.listeners) : Tools.reverseIterable(this.listeners)) {
            listener.beginStart(ctx);
        }
    }

    @Override
    public final void beginEnd(TransactionContext ctx) {
        for (TransactionListener listener : ctx.settings().getTransactionListenerEndInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(this.listeners) : Tools.reverseIterable(this.listeners)) {
            listener.beginEnd(ctx);
        }
    }

    @Override
    public final void commitStart(TransactionContext ctx) {
        for (TransactionListener listener : ctx.settings().getTransactionListenerStartInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(this.listeners) : Tools.reverseIterable(this.listeners)) {
            listener.commitStart(ctx);
        }
    }

    @Override
    public final void commitEnd(TransactionContext ctx) {
        for (TransactionListener listener : ctx.settings().getTransactionListenerEndInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(this.listeners) : Tools.reverseIterable(this.listeners)) {
            listener.commitEnd(ctx);
        }
    }

    @Override
    public final void rollbackStart(TransactionContext ctx) {
        for (TransactionListener listener : ctx.settings().getTransactionListenerStartInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(this.listeners) : Tools.reverseIterable(this.listeners)) {
            listener.rollbackStart(ctx);
        }
    }

    @Override
    public final void rollbackEnd(TransactionContext ctx) {
        for (TransactionListener listener : ctx.settings().getTransactionListenerEndInvocationOrder() != InvocationOrder.REVERSE ? Arrays.asList(this.listeners) : Tools.reverseIterable(this.listeners)) {
            listener.rollbackEnd(ctx);
        }
    }
}

