/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.lib.jooq.impl;

import io.lumine.mythic.bukkit.utils.lib.jooq.Configuration;
import io.lumine.mythic.bukkit.utils.lib.jooq.QueryPart;
import io.lumine.mythic.bukkit.utils.lib.jooq.SQLDialect;
import io.lumine.mythic.bukkit.utils.lib.jooq.conf.Transformation;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.SelectQueryImpl;
import io.lumine.mythic.bukkit.utils.lib.jooq.impl.Tools;
import io.lumine.mythic.bukkit.utils.lib.jooq.tools.StringUtils;
import java.util.Set;
import java.util.function.Predicate;

final class Transformations {
    private static final Set<SQLDialect> NO_SUPPORT_IN_LIMIT = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> SUPPORT_MISSING_TABLE_REFERENCES = SQLDialect.supportedBy(new SQLDialect[0]);
    private static final Set<SQLDialect> EMULATE_QUALIFY = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.FIREBIRD, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> EMULATE_ROWNUM = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);

    Transformations() {
    }

    static final SelectQueryImpl<?> subqueryWithLimit(QueryPart source) {
        SelectQueryImpl s2 = Tools.selectQueryImpl(source);
        return s2 != null && s2.getLimit().isApplicable() ? s2 : null;
    }

    static final boolean transformInConditionSubqueryWithLimitToDerivedTable(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformInConditionSubqueryWithLimitToDerivedTable", configuration.settings().getTransformInConditionSubqueryWithLimitToDerivedTable(), c -> NO_SUPPORT_IN_LIMIT.contains((Object)c.dialect()));
    }

    static final boolean transformQualify(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformQualify", configuration.settings().getTransformQualify(), c -> EMULATE_QUALIFY.contains((Object)c.dialect()));
    }

    static final boolean transformRownum(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformRownum", configuration.settings().getTransformRownum(), c -> EMULATE_ROWNUM.contains((Object)c.dialect()));
    }

    static final boolean transformAppendMissingTableReferences(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformAppendMissingTableReferences", configuration.settings().getParseAppendMissingTableReferences(), c -> SUPPORT_MISSING_TABLE_REFERENCES.contains((Object)c.settings().getParseDialect()));
    }

    static final boolean transform(Configuration configuration, String label, Transformation transformation, Predicate<? super Configuration> whenNeeded) {
        boolean result;
        switch (StringUtils.defaultIfNull(transformation, Transformation.WHEN_NEEDED)) {
            case NEVER: {
                result = false;
                break;
            }
            case ALWAYS: {
                result = true;
                break;
            }
            case WHEN_NEEDED: {
                result = whenNeeded.test(configuration);
                break;
            }
            default: {
                throw new IllegalStateException("Transformation configuration not supported: " + transformation);
            }
        }
        return result && configuration.requireCommercial(() -> "SQL transformation " + label + " required. SQL transformations are a commercial only feature. Please consider upgrading to the jOOQ Professional Edition or jOOQ Enterprise Edition.");
    }
}

