/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.storage;

import com.google.common.collect.ImmutableList;
import java.util.List;

public enum StorageType {
    YAML("YAML", "yaml", "yml"),
    JSON("JSON", "json", "flatfile", "file"),
    MARIADB("MariaDB", "mariadb"),
    MYSQL("MySQL", "mysql"),
    POSTGRESQL("PostgreSQL", "postgresql"),
    SQLITE("SQLite", "sqlite");

    private final String name;
    private final List<String> identifiers;

    private StorageType(String name, String ... identifiers) {
        this.name = name;
        this.identifiers = ImmutableList.copyOf((Object[])identifiers);
    }

    public static StorageType parse(String name, StorageType def) {
        for (StorageType t2 : StorageType.values()) {
            for (String id : t2.getIdentifiers()) {
                if (!id.equalsIgnoreCase(name)) continue;
                return t2;
            }
        }
        return def;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getIdentifiers() {
        return this.identifiers;
    }
}

