/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.holograms.types;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.holograms.IHologram;
import io.lumine.mythic.api.volatilecode.virtual.PacketTextDisplay;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicMobDeathEvent;
import io.lumine.mythic.bukkit.events.MythicMobDespawnEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.bukkit.utils.terminable.TerminableRegistry;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.holograms.HologramManager;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.UUID;

public class Nameplate
implements Terminable {
    private final ActiveMob activemob;
    private final HologramManager manager;
    private IHologram hologram;
    private float yOffset;
    private TerminableRegistry components = TerminableRegistry.create();

    public Nameplate(HologramManager manager, ActiveMob am) {
        this.manager = manager;
        this.activemob = am;
        this.yOffset = am.getType().getConfig().getFloat("Disguise.NameplateOffset", 0.0f);
        this.yOffset = am.getType().getConfig().getFloat("Nameplate.Offset", this.yOffset);
        this.yOffset = (float)((double)this.yOffset + am.getEntity().getNameplateMountOffset());
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_19_4)) {
            PacketTextDisplay.PacketTextDisplayBuilder options = PacketTextDisplay.create().lineWidth(200).backgroundColor(((MythicBukkit)manager.getPlugin()).getConfiguration().getHologramNameplateBackgroundColor()).billboard(((MythicBukkit)manager.getPlugin()).getConfiguration().getHologramNameplateBillboarding()).scale(new AbstractVector(1, 1, 1)).yOffset(Float.valueOf(this.yOffset));
            this.hologram = manager.createHologram(this.activemob.getEntity(), am.getDisplayName(), options);
        } else {
            this.hologram = manager.createHologram("#TempNameplate" + this.activemob.getUniqueId().toString(), this.activemob.getEntity().getLocation(), am.getDisplayName());
        }
        this.components.accept(this.hologram);
        this.components.accept(Events.subscribe(MythicMobDeathEvent.class).handler(event -> {
            UUID uuid = event.getEntity().getUniqueId();
            if (this.activemob.getUniqueId().equals(uuid)) {
                this.terminate();
            }
        }));
        this.components.accept(Events.subscribe(MythicMobDespawnEvent.class).handler(event -> {
            UUID uuid = event.getEntity().getUniqueId();
            if (this.activemob.getUniqueId().equals(uuid)) {
                this.terminate();
            }
        }));
        this.components.accept(Schedulers.async().runRepeating(task -> this.check(), 1L, 10L));
        this.components.accept(Schedulers.async().runRepeating(() -> this.teleport(), 1L, 1L));
    }

    public boolean check() {
        if (this.activemob.isDead() || !this.activemob.getEntity().isValid()) {
            this.terminate();
            return false;
        }
        return true;
    }

    public void teleport() {
        AbstractLocation location = this.getLocation();
        if (location == null) {
            this.terminate();
        } else {
            this.hologram.teleport(this.getLocation());
        }
    }

    @Override
    public void close() {
        this.components.terminate();
    }

    private AbstractLocation getLocation() {
        return this.activemob.getEntity().getEyeLocation().add(0.0, this.yOffset, 0.0);
    }
}

