/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.mobs;

public enum DespawnMode {
    NORMAL(true, false, true, true),
    CHUNK(false, false, true, true),
    NEVER(false, true, false, true),
    PERSISTENT(false, true, false, false);

    private final Boolean despawnWithoutNearbyPlayers;
    private final Boolean savesToDisk;
    private final Boolean despawnsOnUnload;
    private final Boolean obeysKillCommand;

    private DespawnMode(boolean despawnWithoutNearbyPlayers, boolean savesToDisk, boolean despawnsOnUnload, boolean obeysKillCommand) {
        this.despawnWithoutNearbyPlayers = despawnWithoutNearbyPlayers;
        this.savesToDisk = savesToDisk;
        this.despawnsOnUnload = despawnsOnUnload;
        this.obeysKillCommand = obeysKillCommand;
    }

    public static DespawnMode get(String in) {
        switch (in.toUpperCase()) {
            case "NORMAL": 
            case "TRUE": 
            case "YES": {
                return NORMAL;
            }
            case "NEVER": 
            case "FALSE": 
            case "NO": {
                return NEVER;
            }
            case "CHUNK": {
                return CHUNK;
            }
            case "PERSISTENT": {
                return PERSISTENT;
            }
        }
        return NORMAL;
    }

    public Boolean getDespawnWithoutNearbyPlayers() {
        return this.despawnWithoutNearbyPlayers;
    }

    public Boolean getSavesToDisk() {
        return this.savesToDisk;
    }

    public Boolean getDespawnsOnUnload() {
        return this.despawnsOnUnload;
    }

    public Boolean getObeysKillCommand() {
        return this.obeysKillCommand;
    }
}

