/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Collection;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

@MythicCondition(author="Ashijin", name="holding", aliases={}, description="Checks if the target is holding a given material")
public class HoldingCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="material", aliases={"m", "type", "t"}, description="The material type to match")
    private final Collection<BukkitItemStack> comparisons;

    public HoldingCondition(String line, MythicLineConfig mlc) {
        super(line);
        String materialString = mlc.getString(new String[]{"material", "m", "type", "t"}, "DIRT", this.conditionVar);
        this.comparisons = BukkitItemStack.getMatches(materialString);
    }

    @Override
    public boolean check(AbstractEntity target) {
        if (!target.isLiving()) {
            return false;
        }
        EntityEquipment entityEquipment = ((LivingEntity)target.getBukkitEntity()).getEquipment();
        if (entityEquipment != null) {
            ItemStack holding = entityEquipment.getItemInMainHand();
            for (BukkitItemStack item : this.comparisons) {
                if (!item.isSimilar(holding)) continue;
                return true;
            }
        }
        return false;
    }
}

