/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;

@MythicMechanic(name="attributeModifier", description="Adds an attribute modifier to the attributable target")
public class AttributeModifierMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
INoTargetSkill {
    @MythicField(name="attribute", aliases={"attr"}, defValue="GENERIC_LUCK", description="The attribute to modify.")
    private final Attribute attribute;
    @MythicField(name="operation", aliases={"op"}, defValue="ADD_NUMBER", description="The operation to perform for the attribute modifier.")
    private final AttributeModifier.Operation operation;
    @MythicField(name="name", aliases={"modifierName"}, defValue="<caster.uuid>", description="The name of the attribute modifier.")
    private final PlaceholderString name;
    @MythicField(name="amount", aliases={"amt", "a"}, defValue="0", description="The amount to modify the attribute.")
    private final PlaceholderDouble amount;
    @MythicField(name="duration", aliases={"dur"}, defValue="0", description="The duration of the attribute modifier in ticks.")
    private final PlaceholderInt duration;

    public AttributeModifierMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.attribute = mlc.getEnum(new String[]{"attribute", "attr"}, Attribute.class, Attribute.GENERIC_LUCK, "Not a valid attribute given");
        this.operation = mlc.getEnum(new String[]{"operation", "op"}, AttributeModifier.Operation.class, AttributeModifier.Operation.ADD_NUMBER, "Not a valid operation");
        this.name = mlc.getPlaceholderString(new String[]{"name", "modifierName"}, "<caster.uuid>", new String[0]);
        this.amount = mlc.getPlaceholderDouble(new String[]{"amount", "amt", "a"}, 0.0, new String[0]);
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "dur"}, 0, new String[0]);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        Entity entity = data.getCaster().getEntity().getBukkitEntity();
        if (!(entity instanceof Attributable)) {
            return SkillResult.INVALID_TARGET;
        }
        Attributable entity2 = (Attributable)entity;
        AttributeModifier modifier = new AttributeModifier(this.name.get(data), this.amount.get(data), this.operation);
        entity2.getAttribute(this.attribute).addModifier(modifier);
        int duration = this.duration.get(data);
        if (duration > 0) {
            Schedulers.sync().runLater(() -> entity2.getAttribute(this.attribute).removeModifier(modifier), duration);
        }
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity entity = target.getBukkitEntity();
        if (!(entity instanceof Attributable)) {
            return SkillResult.INVALID_TARGET;
        }
        Attributable entity2 = (Attributable)entity;
        AttributeModifier modifier = new AttributeModifier(this.name.get((PlaceholderMeta)data, target), this.amount.get(data, target), this.operation);
        entity2.getAttribute(this.attribute).addModifier(modifier);
        int duration = this.duration.get(data, target);
        if (duration > 0) {
            Schedulers.sync().runLater(() -> entity2.getAttribute(this.attribute).removeModifier(modifier), duration);
        }
        return SkillResult.SUCCESS;
    }
}

