/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.skills.projectiles.ProjectileBullet;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletType;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletableTracker;
import io.lumine.mythic.core.skills.projectiles.ProjectileSurfaceMode;
import io.lumine.mythic.core.utils.VectorUtils;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicFields;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@MythicMechanic(author="Ashijin", name="orbital", aliases={"o"}, description="Applies an orbital aura to the target")
public class OrbitalMechanic
extends Aura
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    @MythicField(name="radius", aliases={"r"}, description="The radius of the orbital aura")
    protected PlaceholderFloat radius;
    @MythicField(name="hitRadius", aliases={"hr"}, description="The hit radius of the orbital aura")
    protected float hitRadius;
    @MythicField(name="verticalHitRadius", aliases={"vhr", "vr"}, description="The vertical hit radius of the orbital aura")
    protected float verticalHitRadius;
    @MythicField(name="points", aliases={"p"}, description="The number of points in the orbital aura")
    protected PlaceholderInt points;
    @MythicField(name="interval", description="The interval between iterations of the orbital aura")
    protected int interval;
    @MythicField(name="iterations", description="The number of iterations of the orbital aura")
    protected int iterations;
    @MythicField(name="velocity", description="The velocity of the orbital aura")
    protected double velocity;
    @MythicField(name="rotate", description="Whether the orbital aura should rotate")
    protected boolean rotate;
    @MythicField(name="reversed", description="Whether the orbital aura should be reversed")
    protected boolean reversed;
    @MythicField(name="startingStep", aliases={"sp"}, description="The starting step of the orbital aura")
    protected PlaceholderInt startingStep;
    @MythicField(name="xRotation", aliases={"rotx", "rx"}, description="The X rotation of the orbital aura")
    protected PlaceholderDouble xRotation;
    @MythicField(name="yRotation", aliases={"roty", "ry"}, description="The Y rotation of the orbital aura")
    protected PlaceholderDouble yRotation;
    @MythicField(name="zRotation", aliases={"rotz", "rz"}, description="The Z rotation of the orbital aura")
    protected PlaceholderDouble zRotation;
    @MythicField(name="xOffset", aliases={"offx", "ox"}, description="The X offset of the orbital aura")
    protected PlaceholderDouble xOffset;
    @MythicField(name="yOffset", aliases={"offy", "oy"}, description="The Y offset of the orbital aura")
    protected PlaceholderDouble yOffset;
    @MythicField(name="zOffset", aliases={"offz", "oz"}, description="The Z offset of the orbital aura")
    protected PlaceholderDouble zOffset;
    @MythicField(name="interpolation", aliases={"tickinterpolation", "ti"}, description="Interpolates additional points between each tick of the projectile, running onTick multiple times", defValue="0")
    protected int tickInterpolation;
    @MythicFields(value={@MythicField(name="hugSurface", aliases={"hs"}, description="Whether the projectile will hug the surface", defValue="false"), @MythicField(name="hugLiquid", aliases={"hugWater", "hugLava"}, description="If hugSurface is set, determines whether the projectile will hug liquid", defValue="false")})
    protected ProjectileSurfaceMode surfaceMode = ProjectileSurfaceMode.NONE;
    @MythicField(name="heightFromSurface", aliases={"hfs"}, description="    The offset depends on the type of the projectile and if hugSurface is set.\n    NORMAL - how high above the surface the projectile will glide.\n    METEOR - how high above the surface the projectile starts above the target\n", defValue="0.5")
    protected float heightFromSurface;
    @MythicField(name="maxClimbHeight", aliases={"mch"}, description="The number of attempts the projectile will try to increase its y-location before terminating the projectile", defValue="3")
    protected float maxClimbHeight;
    @MythicField(name="maxDropHeight", aliases={"mdh"}, description="The number of attempts the projectile will try to decrease its y-location before terminating the projectile", defValue="10")
    protected float maxDropHeight;
    @MythicField(name="onHitSkill", aliases={"onhit", "oh"}, description="The name of the skill to trigger when the orbital aura hits a target")
    protected String onHitSkillName;
    protected Optional<Skill> onHitSkill = Optional.empty();
    @MythicField(name="hitSelf", aliases={"hs"}, description="Whether the orbital aura can hit the caster")
    protected boolean hitSelf;
    @MythicField(name="hitPlayers", aliases={"hp"}, description="Whether the orbital aura can hit players")
    protected boolean hitPlayers;
    @MythicField(name="hitNonPlayers", aliases={"hnp"}, description="Whether the orbital aura can hit non-players")
    protected boolean hitNonPlayers;
    protected Optional<ProjectileBulletType> bulletType;
    protected ProjectileBullet bullet;
    protected double angularVelocityX = 0.015707963267948967;
    protected double angularVelocityY = 0.018479956785822312;
    protected double angularVelocityZ = 0.02026833970057931;

    public OrbitalMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.radius = mlc.getPlaceholderFloat(new String[]{"radius", "r"}, 4.0f, new String[0]);
        this.hitRadius = mlc.getFloat(new String[]{"hitradius", "hr"}, 1.0f);
        this.verticalHitRadius = mlc.getFloat(new String[]{"verticalhitradius", "vhr", "vr"}, this.hitRadius);
        this.points = mlc.getPlaceholderInteger(new String[]{"points", "p"}, 32, new String[0]);
        this.startingStep = mlc.getPlaceholderInteger(new String[]{"startingPoint", "sp"}, 0, new String[0]);
        this.tickInterpolation = mlc.getInteger(new String[]{"tickinterpolation", "interpolation", "ti"}, 0);
        this.xRotation = mlc.getPlaceholderDouble(new String[]{"rotationx", "rotx", "rx"}, 0.0, new String[0]);
        this.yRotation = mlc.getPlaceholderDouble(new String[]{"rotationy", "roty", "ry"}, 0.0, new String[0]);
        this.zRotation = mlc.getPlaceholderDouble(new String[]{"rotationz", "rotz", "rz"}, 0.0, new String[0]);
        this.xOffset = mlc.getPlaceholderDouble(new String[]{"offsetx", "offx", "ox"}, 0.0, new String[0]);
        this.yOffset = mlc.getPlaceholderDouble(new String[]{"offsety", "offy", "oy"}, 0.0, new String[0]);
        this.zOffset = mlc.getPlaceholderDouble(new String[]{"offsetz", "offz", "oz"}, 0.0, new String[0]);
        this.angularVelocityX = mlc.getDouble(new String[]{"angularvelocityx", "avx", "vx"}, 0.0);
        this.angularVelocityY = mlc.getDouble(new String[]{"angularvelocityy", "avy", "vy"}, 0.0);
        this.angularVelocityZ = mlc.getDouble(new String[]{"angularvelocityz", "avz", "vz"}, 0.0);
        this.angularVelocityX = this.angularVelocityX == 0.0 ? 0.0 : Math.PI / this.angularVelocityX;
        this.angularVelocityY = this.angularVelocityY == 0.0 ? 0.0 : Math.PI / this.angularVelocityY;
        this.angularVelocityZ = this.angularVelocityZ == 0.0 ? 0.0 : Math.PI / this.angularVelocityZ;
        this.rotate = mlc.getBoolean(new String[]{"rotate"}, this.angularVelocityX > 0.0 || this.angularVelocityY > 0.0 || this.angularVelocityZ > 0.0);
        this.reversed = mlc.getBoolean(new String[]{"reversed", "reverse", "backwards"}, false);
        this.hitSelf = mlc.getBoolean(new String[]{"hitself", "hs"}, false);
        this.hitPlayers = mlc.getBoolean(new String[]{"hitplayers", "hp"}, true);
        this.hitNonPlayers = mlc.getBoolean(new String[]{"hitnonplayers", "hnp"}, false);
        boolean hugSurface = mlc.getBoolean(new String[]{"hugsurface", "hs"}, false);
        this.heightFromSurface = mlc.getFloat(new String[]{"heightfromsurface", "hfs"}, 0.5f);
        this.maxClimbHeight = mlc.getFloat(new String[]{"maxclimbheight", "mch"}, 3.0f);
        this.maxDropHeight = mlc.getFloat(new String[]{"maxdropheight", "mdh"}, 10.0f);
        if (hugSurface) {
            boolean hugWater = mlc.getBoolean(new String[]{"hugliquid", "hugwater", "huglava"}, false);
            this.surfaceMode = hugWater ? ProjectileSurfaceMode.WATER : ProjectileSurfaceMode.SURFACE;
        }
        this.onHitSkillName = mlc.getString(new String[]{"onhitskill", "onhit", "oh"});
        String bulletType = mlc.getString(new String[]{"bullettype", "bullet", "b"}, "NONE", new String[0]);
        try {
            this.bulletType = ProjectileBulletType.get(bulletType);
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid bullet type specified");
            this.bulletType = Optional.empty();
        }
        if (this.bulletType.isPresent()) {
            this.bullet = this.bulletType.get().create(this, mlc);
        }
        this.getManager().queueSecondPass(() -> {
            if (this.onHitSkillName != null) {
                this.onHitSkill = this.getManager().getSkill(file, this, this.onHitSkillName);
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded orbital onHit pointing at " + this.onHitSkillName, new Object[0]);
        });
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        new OrbitalTracker(data, target);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new OrbitalTracker(data, target);
        return SkillResult.SUCCESS;
    }

    public int getTickInterpolation() {
        return this.tickInterpolation;
    }

    public ProjectileSurfaceMode getSurfaceMode() {
        return this.surfaceMode;
    }

    static /* synthetic */ Optional access$100(OrbitalMechanic x0) {
        return x0.onTickSkill;
    }

    public class OrbitalTracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable,
    ProjectileBulletableTracker {
        private float radius;
        private float power;
        private int iteration;
        private int step;
        private PlaceholderDouble yOffset;
        protected double xRotation;
        protected double yRotation;
        protected double zRotation;
        private SkillMetadata data;
        protected AbstractLocation currentLocation;
        protected AbstractLocation previousLocation;
        protected AbstractVector currentVelocity;
        protected ProjectileBullet.BulletTracker bullet;
        private Set<AbstractEntity> inRange;
        private HashSet<AbstractEntity> targets;
        private Map<AbstractEntity, Long> immune;

        public OrbitalTracker(SkillMetadata data, AbstractEntity entity) {
            super((Aura)OrbitalMechanic.this, entity, data);
            this.iteration = 0;
            this.step = 0;
            this.xRotation = 0.0;
            this.yRotation = 0.0;
            this.zRotation = 0.0;
            this.bullet = null;
            this.inRange = ConcurrentHashMap.newKeySet();
            this.targets = new HashSet();
            this.immune = new HashMap<AbstractEntity, Long>();
            this.data = data;
            this.step = OrbitalMechanic.this.startingStep.get(data);
            this.radius = OrbitalMechanic.this.radius.get(data);
            this.power = data.getPower();
            this.yOffset = OrbitalMechanic.this.yOffset;
            this.xRotation = OrbitalMechanic.this.xRotation.get(data, entity);
            this.yRotation = OrbitalMechanic.this.yRotation.get(data, entity);
            this.zRotation = OrbitalMechanic.this.zRotation.get(data, entity);
            this.start();
        }

        public OrbitalTracker(SkillMetadata data, AbstractLocation location) {
            super((Aura)OrbitalMechanic.this, location, data);
            this.iteration = 0;
            this.step = 0;
            this.xRotation = 0.0;
            this.yRotation = 0.0;
            this.zRotation = 0.0;
            this.bullet = null;
            this.inRange = ConcurrentHashMap.newKeySet();
            this.targets = new HashSet();
            this.immune = new HashMap<AbstractEntity, Long>();
            this.data = data;
            this.step = OrbitalMechanic.this.startingStep.get(data);
            this.radius = OrbitalMechanic.this.radius.get(data);
            this.power = data.getPower();
            this.yOffset = OrbitalMechanic.this.yOffset;
            this.xRotation = OrbitalMechanic.this.xRotation.get(data);
            this.yRotation = OrbitalMechanic.this.yRotation.get(data);
            this.zRotation = OrbitalMechanic.this.zRotation.get(data);
            this.start();
        }

        public AbstractLocation getLocation() {
            AbstractLocation loc = null;
            if (this.entity.isPresent()) {
                loc = ((AbstractEntity)this.entity.get()).getLocation().add(OrbitalMechanic.this.xOffset.get(this.getSkillMetadata()), this.yOffset.get(this.getSkillMetadata()), OrbitalMechanic.this.zOffset.get(this.getSkillMetadata()));
            } else if (this.location.isPresent()) {
                loc = ((AbstractLocation)this.location.get()).clone().add(OrbitalMechanic.this.xOffset.get(this.getSkillMetadata()), this.yOffset.get(this.getSkillMetadata()), OrbitalMechanic.this.zOffset.get(this.getSkillMetadata()));
            }
            return loc;
        }

        public AbstractVector getNextPositionOffset() {
            double inc = Math.PI * 2 / (double)OrbitalMechanic.this.points.get(this.skillMetadata);
            double angle = OrbitalMechanic.this.reversed ? (double)(-this.step) * inc : (double)this.step * inc;
            AbstractVector v = new AbstractVector(0, 0, 0);
            v.setX(Math.cos(angle) * (double)this.radius);
            v.setZ(Math.sin(angle) * (double)this.radius);
            VectorUtils.rotateVector(v, this.xRotation, this.yRotation, this.zRotation);
            if (OrbitalMechanic.this.rotate) {
                VectorUtils.rotateVector(v, OrbitalMechanic.this.angularVelocityX * (double)this.step, OrbitalMechanic.this.angularVelocityY * (double)this.step, OrbitalMechanic.this.angularVelocityZ * (double)this.step);
            }
            return v;
        }

        @Override
        public double getVelocityMagnitude() {
            if (this.currentVelocity == null) {
                return 0.0;
            }
            double x = this.currentVelocity.getX();
            double y = this.currentVelocity.getY();
            double z = this.currentVelocity.getZ();
            return Math.sqrt(x * x + y * y + z * z);
        }

        @Override
        public void auraStart() {
            if (OrbitalMechanic.this.hitSelf || OrbitalMechanic.this.hitPlayers || OrbitalMechanic.this.hitNonPlayers) {
                this.inRange.addAll(((MythicBukkit)OrbitalMechanic.this.getPlugin()).getEntityManager().getLivingEntities(this.skillMetadata.getOrigin().getWorld()));
                this.inRange.removeIf(e -> {
                    if (e != null) {
                        if (!OrbitalMechanic.this.hitSelf && e.getUniqueId().equals(this.skillMetadata.getCaster().getEntity().getUniqueId())) {
                            return true;
                        }
                        if (!OrbitalMechanic.this.hitPlayers && e.isPlayer()) {
                            return true;
                        }
                        return !OrbitalMechanic.this.hitNonPlayers && !e.isPlayer();
                    }
                    return true;
                });
            }
            if (this.previousLocation == null) {
                this.previousLocation = this.getLocation();
                this.previousLocation = this.previousLocation.add(this.getNextPositionOffset());
                this.currentVelocity = new AbstractVector(0, 0, 0);
            }
            if (OrbitalMechanic.this.bullet != null) {
                Schedulers.ensureSync(() -> {
                    this.bullet = OrbitalMechanic.this.bullet.create(this, null);
                    this.bullet.spawn(this.previousLocation);
                });
            }
            this.executeAuraSkill(OrbitalMechanic.this.onStartSkill, this.skillMetadata.deepClone().setOrigin(this.previousLocation));
        }

        /*
         * Exception decompiling
         */
        @Override
        public void auraTick() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[UNCONDITIONALDOLOOP]], but top level block is 10[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void auraStop() {
            this.executeAuraSkill(OrbitalMechanic.this.onEndSkill, this.skillMetadata.deepClone().setOrigin(this.previousLocation));
            if (OrbitalMechanic.this.bulletType.isPresent()) {
                Schedulers.sync().runLater(() -> {
                    if (this.bullet != null) {
                        this.bullet.despawn();
                    }
                }, 0L);
            }
        }

        public void setRadius(float p) {
            this.radius = p;
        }

        public void multiplyRadius(float p) {
            this.radius *= p;
        }

        public void addRadius(float p) {
            this.radius += p;
        }

        public void multiplyYOffset(float value) {
            this.yOffset = PlaceholderDouble.of(String.valueOf(this.yOffset.get() * (double)value));
        }

        public void addYOffset(float value) {
            this.yOffset = PlaceholderDouble.of(String.valueOf(this.yOffset.get() + (double)value));
        }

        public void setYOffset(float value) {
            this.yOffset = PlaceholderDouble.of(String.valueOf(value));
        }

        @Override
        public SkillMetadata getData() {
            return this.data;
        }

        @Override
        public AbstractLocation getCurrentLocation() {
            return this.currentLocation;
        }

        @Override
        public AbstractLocation getPreviousLocation() {
            return this.previousLocation;
        }

        @Override
        public AbstractVector getCurrentVelocity() {
            return this.currentVelocity;
        }

        @Override
        public ProjectileBullet.BulletTracker getBullet() {
            return this.bullet;
        }

        private static /* synthetic */ boolean lambda$auraTick$2(Map.Entry entry) {
            return (Long)entry.getValue() < System.currentTimeMillis() - 2000L;
        }
    }
}

