/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.stats.types;

import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.stats.StatExecution;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.stats.PercentModifyer;
import io.lumine.mythic.core.skills.stats.StatExecutor;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatType;
import io.lumine.mythic.core.skills.stats.Stats;
import io.lumine.mythic.core.skills.stats.TriggerModifyingStat;
import io.lumine.mythic.core.skills.triggers.SkillTriggerMetadata;
import io.lumine.mythic.core.skills.triggers.meta.EntityAttackMetadata;
import java.util.Optional;
import org.bukkit.event.entity.EntityDamageEvent;

public class DodgeChanceStat
extends StatType
implements PercentModifyer,
TriggerModifyingStat {
    public DodgeChanceStat(String key) {
        super(key);
    }

    @Override
    public void initialize(StatExecutor manager) {
        super.initialize(manager);
        this.executionPoint = StatExecution.PRE;
        this.getApplicableTriggers().add(SkillTriggers.DAMAGED);
    }

    @Override
    public void processTrigger(SkillMetadata skillMetadata, SkillTriggerMetadata triggerMetadata, StatRegistry statRegistry, double value) {
        if (triggerMetadata instanceof EntityAttackMetadata) {
            double roll;
            EntityAttackMetadata attackMetadata = (EntityAttackMetadata)triggerMetadata;
            if (attackMetadata.getEvent().getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                return;
            }
            Optional<StatRegistry> maybeRegistry = this.getManager().getStatRegistry(attackMetadata.getDamager());
            double accuracy = maybeRegistry.isPresent() ? maybeRegistry.get().get(Stats.DODGE_NEGATION) : 0.0;
            if (value - accuracy >= (roll = Numbers.randomDouble())) {
                attackMetadata.setDamage(0.0);
                attackMetadata.putBoolean("dodge", true);
                this.runProcSkills(skillMetadata, triggerMetadata);
            }
        }
    }
}

