/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.pins.Pin;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

@MythicTargeter(author="Ashijin", name="pin", aliases={}, description="Targets the location of a saved pin")
public class PinTargeter
extends ILocationSelector {
    protected String key;

    public PinTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.key = mlc.getString(new String[]{"name", "n", "pin", "p", "key", "k"}, null, new String[0]);
        if (this.key == null) {
            MythicLogger.errorTargeterConfig(this, mlc, "Pin name must be set.");
            return;
        }
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        ArrayList targets = Lists.newArrayList();
        Optional<Pin> maybePin = this.getPlugin().getPinManager().getPin(this.key);
        if (maybePin.isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Pin {0} is not defined", this.key);
            return targets;
        }
        Pin pin = maybePin.get();
        for (AbstractLocation pinLocation : pin.getLocations()) {
            targets.add(this.mutate(data, pinLocation));
        }
        return targets;
    }
}

