/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.serialize.GsonStorageHandler;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.skills.variables.VariableScope;
import java.io.File;
import java.util.Optional;

public class VariableManager
extends ReloadableModule<MythicBukkit>
implements Terminable {
    private final GsonStorageHandler<VariableRegistry> globalRegistryReader;
    private VariableRegistry globalRegistry;
    private boolean loaded = false;

    public VariableManager(MythicBukkit plugin) {
        super(plugin, false);
        File dataFolder = new File(plugin.getDataFolder(), "SavedData");
        this.globalRegistryReader = new GsonStorageHandler<VariableRegistry>("global-data", ".json", dataFolder, VariableRegistry.class);
        this.load(plugin);
    }

    @Override
    public void load(MythicBukkit plugin) {
        Optional maybeRegistry = this.globalRegistryReader.load();
        this.globalRegistry = maybeRegistry.isPresent() ? (VariableRegistry)maybeRegistry.get() : new VariableRegistry();
        this.loaded = true;
    }

    @Override
    public void unload() {
        this.globalRegistryReader.save(this.globalRegistry);
    }

    public void save() {
        if (!this.loaded) {
            return;
        }
        Schedulers.ensureAsync(() -> this.globalRegistryReader.save(this.globalRegistry));
    }

    public VariableRegistry getRegistry(VariableScope scope, SkillMetadata meta) {
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Getting VariableRegistry in scope {0}", new Object[]{scope});
        switch (scope) {
            case CASTER: {
                SkillCaster caster = meta.getCaster();
                if (caster == null) {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "! Can't get registry for null caster", new Object[0]);
                    return null;
                }
                if (caster instanceof ActiveMob) {
                    ActiveMob activeMob = (ActiveMob)caster;
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting caster mob registry...", new Object[0]);
                    return activeMob.getVariables();
                }
                if (caster.getEntity().isPlayer()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting caster player registry...", new Object[0]);
                    return ((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(caster.getEntity().asPlayer()).getVariables();
                }
                return null;
            }
            case SKILL: {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting skill registry...", new Object[0]);
                return meta.getVariables();
            }
            case TARGET: {
                return null;
            }
            case WORLD: {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting world registry...", new Object[0]);
                SkillCaster caster = meta.getCaster();
                if (caster != null) {
                    return ((MythicBukkit)this.getPlugin()).getWorldManager().getWorldData(caster.getEntity().getWorld()).getVariables();
                }
                return null;
            }
            case GLOBAL: {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting global registry...", new Object[0]);
                return this.globalRegistry;
            }
        }
        return null;
    }

    public VariableRegistry getRegistry(VariableScope scope, PlaceholderMeta meta, AbstractEntity entity) {
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Getting VariableRegistry in scope {0}", new Object[]{scope});
        switch (scope) {
            case CASTER: {
                SkillCaster caster = meta.getCaster();
                if (caster == null) {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "! Can't get registry for null caster", new Object[0]);
                    return null;
                }
                if (caster instanceof ActiveMob) {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting caster mob registry...", new Object[0]);
                    return ((ActiveMob)caster).getVariables();
                }
                if (caster.getEntity().isPlayer()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting caster player registry...", new Object[0]);
                    return ((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(caster.getEntity().asPlayer()).getVariables();
                }
                return null;
            }
            case SKILL: {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting skill registry...", new Object[0]);
                if (meta instanceof SkillMetadata) {
                    SkillMetadata skillMetadata = (SkillMetadata)meta;
                    return skillMetadata.getVariables();
                }
                return null;
            }
            case TARGET: {
                if (((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(entity)) {
                    MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting target mob registry...", new Object[0]);
                    return ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(entity).getVariables();
                }
                if (!entity.isPlayer()) break;
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting target player registry...", new Object[0]);
                return ((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(entity.asPlayer()).getVariables();
            }
            case WORLD: {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting world registry...", new Object[0]);
                SkillCaster caster = meta.getCaster();
                if (caster != null) {
                    return ((MythicBukkit)this.getPlugin()).getWorldManager().getWorldData(caster.getEntity().getWorld()).getVariables();
                }
                if (entity != null) {
                    return ((MythicBukkit)this.getPlugin()).getWorldManager().getWorldData(entity.getWorld()).getVariables();
                }
                return null;
            }
            case GLOBAL: {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting global registry...", new Object[0]);
                return this.globalRegistry;
            }
        }
        return null;
    }

    public VariableRegistry getRegistry(VariableScope scope, AbstractEntity entity) {
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Getting VariableRegistry for entity {} in scope {}", new Object[]{entity.getName(), scope});
        switch (scope) {
            case CASTER: {
                if (((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(entity)) {
                    return ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(entity).getVariables();
                }
                if (!entity.isPlayer()) break;
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting target player registry...", new Object[0]);
                return ((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(entity.asPlayer()).getVariables();
            }
            case SKILL: {
                break;
            }
            case TARGET: {
                if (((MythicBukkit)this.getPlugin()).getMobManager().isActiveMob(entity)) {
                    return ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(entity).getVariables();
                }
                if (!entity.isPlayer()) break;
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ Getting target player registry...", new Object[0]);
                return ((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(entity.asPlayer()).getVariables();
            }
            case WORLD: {
                return ((MythicBukkit)this.getPlugin()).getWorldManager().getWorldData(entity.getWorld()).getVariables();
            }
            case GLOBAL: {
                return this.globalRegistry;
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "! Can't get caster registry in this context", new Object[0]);
        return null;
    }

    public VariableRegistry getRegistry(ActiveMob am) {
        return am.getVariables();
    }

    public VariableRegistry getRegistry(VariableScope scope, AbstractLocation target) {
        switch (scope) {
            case CASTER: {
                return null;
            }
            case SKILL: {
                break;
            }
            case TARGET: {
                break;
            }
            case WORLD: {
                return ((MythicBukkit)this.getPlugin()).getWorldManager().getWorldData(target.getWorld()).getVariables();
            }
            case GLOBAL: {
                return this.globalRegistry;
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "! Can't get caster registry in this context", new Object[0]);
        return null;
    }

    public VariableRegistry getGlobalRegistry() {
        return this.globalRegistry;
    }
}

