/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import pers.neige.neigeitems.javassist.ClassPool;
import pers.neige.neigeitems.javassist.bytecode.ConstPool;
import pers.neige.neigeitems.javassist.bytecode.annotation.AnnotationsWriter;
import pers.neige.neigeitems.javassist.bytecode.annotation.MemberValue;
import pers.neige.neigeitems.javassist.bytecode.annotation.MemberValueVisitor;

public class FloatMemberValue
extends MemberValue {
    int valueIndex;

    public FloatMemberValue(int index, ConstPool cp) {
        super('F', cp);
        this.valueIndex = index;
    }

    public FloatMemberValue(float f, ConstPool cp) {
        super('F', cp);
        this.setValue(f);
    }

    public FloatMemberValue(ConstPool cp) {
        super('F', cp);
        this.setValue(0.0f);
    }

    @Override
    Object getValue(ClassLoader cl, ClassPool cp, Method m) {
        return new Float(this.getValue());
    }

    @Override
    Class getType(ClassLoader cl) {
        return Float.TYPE;
    }

    public float getValue() {
        return this.cp.getFloatInfo(this.valueIndex);
    }

    public void setValue(float newValue) {
        this.valueIndex = this.cp.addFloatInfo(newValue);
    }

    public String toString() {
        return Float.toString(this.getValue());
    }

    @Override
    public void write(AnnotationsWriter writer) throws IOException {
        writer.constValueIndex(this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor visitor) {
        visitor.visitFloatMemberValue(this);
    }
}

