/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin1720.collections.CollectionsKt;
import kotlin1720.jvm.JvmStatic;
import kotlin1720.jvm.internal.Intrinsics;
import kotlin1720.ranges.RangesKt;
import kotlin1720.text.CharsKt;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.neige.neigeitems.NeigeItems;
import pers.neige.neigeitems.item.ItemConfig;
import pers.neige.neigeitems.item.ItemGenerator;
import pers.neige.neigeitems.item.ItemInfo;
import pers.neige.neigeitems.manager.ConfigManager;
import pers.neige.neigeitems.manager.ItemConfigManager;
import pers.neige.neigeitems.taboolib.module.nms.ItemTag;
import pers.neige.neigeitems.taboolib.module.nms.ItemTagData;
import pers.neige.neigeitems.taboolib.module.nms.NMSItemTagKt;
import pers.neige.neigeitems.utils.ConfigUtils;
import pers.neige.neigeitems.utils.ItemUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\tJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\tJ&\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\t2\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u0015J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\tJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J0\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u0015J$\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0011\u001a\u00020\tJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\tJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0013J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001cJ\b\u0010!\u001a\u00020\u000eH\u0002J\u0006\u0010\"\u001a\u00020\u000eJ.\u0010#\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001cJ(\u0010#\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\t2\b\b\u0002\u0010)\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u001cJ\u0014\u0010*\u001a\u00020\u000e*\u00020\u00132\u0006\u0010+\u001a\u00020\u0004H\u0007J\u0014\u0010,\u001a\u00020\u000e*\u00020\u00132\u0006\u0010+\u001a\u00020\u0004H\u0007J\u0014\u0010-\u001a\u00020\u000e*\u00020\u00132\u0006\u0010+\u001a\u00020\u0004H\u0007J\u0014\u0010.\u001a\u00020\u000e*\u00020\u00132\u0006\u0010+\u001a\u00020\u0004H\u0007J\u0014\u0010/\u001a\u00020\u000e*\u00020\u00132\u0006\u0010+\u001a\u00020\u0004H\u0007J\u0014\u00100\u001a\u00020\u000e*\u00020\u00132\u0006\u0010+\u001a\u00020\u0004H\u0007J\u0014\u00101\u001a\u00020\u000e*\u00020\u00132\u0006\u0010+\u001a\u00020\u0004H\u0007J\u0014\u00102\u001a\u00020\u000e*\u00020\u00132\u0006\u0010+\u001a\u00020\u0004H\u0007R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00063"}, d2={"Lpers/neige/neigeitems/manager/ItemManager;", "Lpers/neige/neigeitems/manager/ItemConfigManager;", "()V", "itemAmount", "", "getItemAmount", "()I", "items", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lpers/neige/neigeitems/item/ItemGenerator;", "getItems", "()Ljava/util/concurrent/ConcurrentHashMap;", "addItem", "", "itemGenerator", "getItem", "id", "getItemStack", "Lorg/bukkit/inventory/ItemStack;", "data", "Ljava/util/HashMap;", "player", "Lorg/bukkit/OfflinePlayer;", "getOriginConfig", "Lorg/bukkit/configuration/ConfigurationSection;", "getRealOriginConfig", "hasItem", "", "isNiItem", "Lpers/neige/neigeitems/item/ItemInfo;", "itemStack", "parseData", "loadItems", "reload", "saveItem", "file", "Ljava/io/File;", "config", "Lorg/bukkit/configuration/file/YamlConfiguration;", "cover", "path", "addCharge", "amount", "addCustomDurability", "addMaxCharge", "addMaxCustomDurability", "setCharge", "setCustomDurability", "setMaxCharge", "setMaxCustomDurability", "NeigeItems"})
public final class ItemManager
extends ItemConfigManager {
    @NotNull
    public static final ItemManager INSTANCE = new ItemManager();
    @NotNull
    private static final ConcurrentHashMap<String, ItemGenerator> items = new ConcurrentHashMap();

    private ItemManager() {
    }

    @NotNull
    public final ConcurrentHashMap<String, ItemGenerator> getItems() {
        return items;
    }

    public final int getItemAmount() {
        return this.getItemIds().size();
    }

    private final void loadItems() {
        long time = System.currentTimeMillis();
        for (Map.Entry entry : ((Map)this.getItemConfigs()).entrySet()) {
            String id = (String)entry.getKey();
            ItemConfig itemConfig = (ItemConfig)entry.getValue();
            ((Map)items).put(id, new ItemGenerator(itemConfig));
            if (!ConfigManager.INSTANCE.getDebug()) continue;
            long current = System.currentTimeMillis() - time;
            if (current > 1L) {
                System.out.println((Object)("  \u7269\u54c1-" + id + "-\u52a0\u8f7d\u8017\u65f6: " + current + "ms"));
            }
            time = System.currentTimeMillis();
        }
    }

    private final void addItem(ItemGenerator itemGenerator) {
        ((Map)this.getItemConfigs()).put(itemGenerator.getId(), itemGenerator.getItemConfig());
        ((Map)items).put(itemGenerator.getId(), itemGenerator);
    }

    public final void reload() {
        this.reloadItemConfigs();
        items.clear();
        this.loadItems();
    }

    @Nullable
    public final ConfigurationSection getOriginConfig(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ItemConfig itemConfig = this.getItemConfigs().get(id);
        return itemConfig != null && (itemConfig = itemConfig.getConfigSection()) != null ? ConfigUtils.clone((ConfigurationSection)itemConfig) : null;
    }

    @Nullable
    public final ConfigurationSection getRealOriginConfig(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ItemConfig itemConfig = this.getItemConfigs().get(id);
        return itemConfig != null ? itemConfig.getConfigSection() : null;
    }

    @Nullable
    public final ItemGenerator getItem(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return items.get(id);
    }

    @Nullable
    public final ItemStack getItemStack(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getItemStack(id, (OfflinePlayer)null, (HashMap<String, String>)null);
    }

    @Nullable
    public final ItemStack getItemStack(@NotNull String id, @Nullable OfflinePlayer player) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getItemStack(id, player, (HashMap<String, String>)null);
    }

    @Nullable
    public final ItemStack getItemStack(@NotNull String id, @Nullable String data) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getItemStack(id, null, data);
    }

    @Nullable
    public final ItemStack getItemStack(@NotNull String id, @Nullable HashMap<String, String> data) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getItemStack(id, null, data);
    }

    @Nullable
    public final ItemStack getItemStack(@NotNull String id, @Nullable OfflinePlayer player, @Nullable String data) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ItemGenerator itemGenerator = items.get(id);
        return itemGenerator != null ? itemGenerator.getItemStack(player, data) : null;
    }

    @Nullable
    public final ItemStack getItemStack(@NotNull String id, @Nullable OfflinePlayer player, @Nullable HashMap<String, String> data) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ItemGenerator itemGenerator = items.get(id);
        return itemGenerator != null ? itemGenerator.getItemStack(player, data) : null;
    }

    public final boolean hasItem(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return items.containsKey(id);
    }

    /*
     * WARNING - void declaration
     */
    public final int saveItem(@NotNull ItemStack itemStack, @NotNull String id, @NotNull File file, @NotNull YamlConfiguration config, boolean cover2) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (itemStack.getType() != Material.AIR) {
            if (!this.hasItem(id) || cover2) {
                ConfigurationSection configurationSection = config.createSection(id);
                Intrinsics.checkNotNullExpressionValue((Object)configurationSection, (String)"config.createSection(id)");
                ConfigurationSection configSection = configurationSection;
                configSection.set("material", (Object)itemStack.getType().toString());
                if (itemStack.getDurability() > 0) {
                    configSection.set("damage", (Object)itemStack.getDurability());
                }
                if (itemStack.hasItemMeta()) {
                    ItemTagData itemTagData;
                    Object object;
                    Object it;
                    Object object2;
                    Object level;
                    ItemMeta itemMeta = itemStack.getItemMeta();
                    ItemTag itemNBT2 = NMSItemTagKt.getItemTag(itemStack);
                    ItemTagData display = (ItemTagData)itemNBT2.get("display");
                    itemNBT2.remove("display");
                    try {
                        ItemMeta itemMeta2 = itemMeta;
                        boolean bl = itemMeta2 != null ? itemMeta2.hasCustomModelData() : false;
                        if (bl) {
                            configSection.set("custommodeldata", (Object)itemMeta.getCustomModelData());
                        }
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    ItemMeta itemMeta3 = itemMeta;
                    boolean bl = itemMeta3 != null ? itemMeta3.hasDisplayName() : false;
                    if (bl) {
                        configSection.set("name", (Object)itemMeta.getDisplayName());
                    }
                    ItemMeta itemMeta4 = itemMeta;
                    boolean bl2 = itemMeta4 != null ? itemMeta4.hasLore() : false;
                    if (bl2) {
                        configSection.set("lore", (Object)itemMeta.getLore());
                    }
                    ItemMeta itemMeta5 = itemMeta;
                    boolean bl3 = itemMeta5 != null ? itemMeta5.isUnbreakable() : false;
                    if (bl3) {
                        configSection.set("unbreakable", (Object)itemMeta.isUnbreakable());
                    }
                    ItemMeta itemMeta6 = itemMeta;
                    boolean bl4 = itemMeta6 != null ? itemMeta6.hasEnchants() : false;
                    if (bl4) {
                        ConfigurationSection configurationSection2 = configSection.createSection("enchantments");
                        Intrinsics.checkNotNullExpressionValue((Object)configurationSection2, (String)"configSection.createSection(\"enchantments\")");
                        ConfigurationSection enchantSection = configurationSection2;
                        Map map = itemMeta.getEnchants();
                        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"itemMeta.enchants");
                        for (Map.Entry entry : map.entrySet()) {
                            Enchantment enchant = (Enchantment)entry.getKey();
                            level = (Integer)entry.getValue();
                            enchantSection.set(enchant.getName(), level);
                        }
                    }
                    if ((object2 = itemMeta) != null && (object2 = object2.getItemFlags()) != null) {
                        it = object2;
                        boolean bl5 = false;
                        if (!((Collection)it).isEmpty()) {
                            Collection<String> collection;
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            level = (Iterable)it;
                            String string = "hideflags";
                            object = configSection;
                            boolean $i$f$map = false;
                            void var18_23 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void flag;
                                ItemFlag itemFlag = (ItemFlag)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl6 = false;
                                collection.add(flag.name());
                            }
                            collection = (List)destination$iv$iv;
                            object.set(string, (Object)collection);
                        }
                    }
                    if ((itemTagData = display) != null && (itemTagData = itemTagData.asCompound()) != null) {
                        it = itemTagData;
                        boolean bl7 = false;
                        ItemTagData itemTagData2 = (ItemTagData)((ItemTag)it).get("color");
                        if (itemTagData2 != null) {
                            int color = itemTagData2.asInt();
                            boolean bl8 = false;
                            String string = Integer.toString(color, CharsKt.checkRadix((int)16));
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
                            object = string;
                            Locale locale = Locale.getDefault();
                            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                            String string2 = ((String)object).toUpperCase(locale);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
                            configSection.set("color", (Object)string2);
                        }
                    }
                    if (!itemNBT2.isEmpty()) {
                        configSection.set("nbt", ItemUtils.toMap(itemNBT2, (List<String>)ItemUtils.INSTANCE.getInvalidNBT()));
                    }
                }
                config.save(file);
                this.addItem(new ItemGenerator(new ItemConfig(id, file, config)));
                if (cover2) {
                    return 0;
                }
                return 1;
            }
            return 0;
        }
        return 2;
    }

    public final int saveItem(@NotNull ItemStack itemStack, @NotNull String id, @NotNull String path, boolean cover2) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(NeigeItems.INSTANCE.getPlugin().getDataFolder(), File.separator + "Items" + File.separator + path);
        if (!file.exists()) {
            file.createNewFile();
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue((Object)yamlConfiguration, (String)"loadConfiguration(file)");
        YamlConfiguration config = yamlConfiguration;
        return this.saveItem(itemStack, id, file, config, cover2);
    }

    public static /* synthetic */ int saveItem$default(ItemManager itemManager, ItemStack itemStack, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = string + ".yml";
        }
        return itemManager.saveItem(itemStack, string, string2, bl);
    }

    @Nullable
    public final ItemInfo isNiItem(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return ItemUtils.isNiItem(itemStack, false);
    }

    @Nullable
    public final ItemInfo isNiItem(@NotNull ItemStack itemStack, boolean parseData) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return ItemUtils.isNiItem(itemStack, parseData);
    }

    @JvmStatic
    public static final void setCharge(@NotNull ItemStack $this$setCharge, int amount) {
        Intrinsics.checkNotNullParameter((Object)$this$setCharge, (String)"<this>");
        ItemTag itemTag = NMSItemTagKt.getItemTag($this$setCharge);
        ItemTagData itemTagData = ItemUtils.getDeepOrNull(itemTag, "NeigeItems.maxCharge");
        if (itemTagData == null) {
            return;
        }
        int maxCharge = itemTagData.asInt();
        int newCharge = RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)amount, (int)maxCharge), (int)0);
        ItemUtils.putDeepFixed(itemTag, "NeigeItems.charge", new ItemTagData(maxCharge));
        itemTag.saveTo($this$setCharge);
    }

    @JvmStatic
    public static final void addCharge(@NotNull ItemStack $this$addCharge, int amount) {
        Intrinsics.checkNotNullParameter((Object)$this$addCharge, (String)"<this>");
        ItemTag itemTag = NMSItemTagKt.getItemTag($this$addCharge);
        ItemTagData itemTagData = ItemUtils.getDeepOrNull(itemTag, "NeigeItems.charge");
        if (itemTagData == null) {
            return;
        }
        int charge = itemTagData.asInt();
        ItemTagData itemTagData2 = ItemUtils.getDeepOrNull(itemTag, "NeigeItems.maxCharge");
        Intrinsics.checkNotNull((Object)itemTagData2);
        int maxCharge = itemTagData2.asInt();
        int newCharge = RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)(charge + amount), (int)maxCharge), (int)0);
        ItemUtils.putDeepFixed(itemTag, "NeigeItems.charge", new ItemTagData(newCharge));
        itemTag.saveTo($this$addCharge);
    }

    @JvmStatic
    public static final void setMaxCharge(@NotNull ItemStack $this$setMaxCharge, int amount) {
        Intrinsics.checkNotNullParameter((Object)$this$setMaxCharge, (String)"<this>");
        ItemTag itemTag = NMSItemTagKt.getItemTag($this$setMaxCharge);
        ItemTagData itemTagData = ItemUtils.getDeepOrNull(itemTag, "NeigeItems.charge");
        if (itemTagData == null) {
            return;
        }
        int charge = RangesKt.coerceAtMost((int)itemTagData.asInt(), (int)RangesKt.coerceAtLeast((int)amount, (int)1));
        ItemUtils.putDeepFixed(itemTag, "NeigeItems.charge", new ItemTagData(charge));
        ItemUtils.putDeepFixed(itemTag, "NeigeItems.maxCharge", new ItemTagData(RangesKt.coerceAtLeast((int)amount, (int)1)));
        itemTag.saveTo($this$setMaxCharge);
    }

    @JvmStatic
    public static final void addMaxCharge(@NotNull ItemStack $this$addMaxCharge, int amount) {
        Intrinsics.checkNotNullParameter((Object)$this$addMaxCharge, (String)"<this>");
        ItemTag itemTag = NMSItemTagKt.getItemTag($this$addMaxCharge);
        ItemTagData itemTagData = ItemUtils.getDeepOrNull(itemTag, "NeigeItems.maxCharge");
        if (itemTagData == null) {
            return;
        }
        int maxCharge = RangesKt.coerceAtLeast((int)(itemTagData.asInt() + amount), (int)1);
        ItemTagData itemTagData2 = ItemUtils.getDeepOrNull(itemTag, "NeigeItems.charge");
        Intrinsics.checkNotNull((Object)itemTagData2);
        int charge = RangesKt.coerceAtMost((int)itemTagData2.asInt(), (int)maxCharge);
        ItemUtils.putDeepFixed(itemTag, "NeigeItems.charge", new ItemTagData(charge));
        ItemUtils.putDeepFixed(itemTag, "NeigeItems.maxCharge", new ItemTagData(maxCharge));
        itemTag.saveTo($this$addMaxCharge);
    }

    @JvmStatic
    public static final void setCustomDurability(@NotNull ItemStack $this$setCustomDurability, int amount) {
        Intrinsics.checkNotNullParameter((Object)$this$setCustomDurability, (String)"<this>");
        ItemTag itemTag = NMSItemTagKt.getItemTag($this$setCustomDurability);
        ItemTagData itemTagData = ItemUtils.getDeepOrNull(itemTag, "NeigeItems.maxDurability");
        if (itemTagData == null) {
            return;
        }
        int maxDurability = itemTagData.asInt();
        int newDurability = RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)amount, (int)maxDurability), (int)0);
        ItemUtils.putDeepFixed(itemTag, "NeigeItems.durability", new ItemTagData(newDurability));
        $this$setCustomDurability.setDurability((short)((double)$this$setCustomDurability.getDurability() * (1.0 - (double)newDurability / (double)maxDurability)));
        itemTag.saveTo($this$setCustomDurability);
    }

    @JvmStatic
    public static final void addCustomDurability(@NotNull ItemStack $this$addCustomDurability, int amount) {
        Intrinsics.checkNotNullParameter((Object)$this$addCustomDurability, (String)"<this>");
        ItemTag itemTag = NMSItemTagKt.getItemTag($this$addCustomDurability);
        ItemTagData itemTagData = ItemUtils.getDeepOrNull(itemTag, "NeigeItems.durability");
        if (itemTagData == null) {
            return;
        }
        int durability = itemTagData.asInt();
        ItemTagData itemTagData2 = ItemUtils.getDeepOrNull(itemTag, "NeigeItems.maxDurability");
        Intrinsics.checkNotNull((Object)itemTagData2);
        int maxDurability = itemTagData2.asInt();
        int newDurability = RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)(durability + amount), (int)maxDurability), (int)0);
        ItemUtils.putDeepFixed(itemTag, "NeigeItems.durability", new ItemTagData(newDurability));
        $this$addCustomDurability.setDurability((short)((double)$this$addCustomDurability.getDurability() * (1.0 - (double)newDurability / (double)maxDurability)));
        itemTag.saveTo($this$addCustomDurability);
    }

    @JvmStatic
    public static final void setMaxCustomDurability(@NotNull ItemStack $this$setMaxCustomDurability, int amount) {
        Intrinsics.checkNotNullParameter((Object)$this$setMaxCustomDurability, (String)"<this>");
        ItemTag itemTag = NMSItemTagKt.getItemTag($this$setMaxCustomDurability);
        ItemTagData itemTagData = ItemUtils.getDeepOrNull(itemTag, "NeigeItems.durability");
        if (itemTagData == null) {
            return;
        }
        int durability = RangesKt.coerceAtMost((int)itemTagData.asInt(), (int)RangesKt.coerceAtLeast((int)amount, (int)1));
        ItemUtils.putDeepFixed(itemTag, "NeigeItems.durability", new ItemTagData(durability));
        ItemUtils.putDeepFixed(itemTag, "NeigeItems.maxDurability", new ItemTagData(RangesKt.coerceAtLeast((int)amount, (int)1)));
        $this$setMaxCustomDurability.setDurability((short)((double)$this$setMaxCustomDurability.getDurability() * (1.0 - (double)durability / (double)amount)));
        itemTag.saveTo($this$setMaxCustomDurability);
    }

    @JvmStatic
    public static final void addMaxCustomDurability(@NotNull ItemStack $this$addMaxCustomDurability, int amount) {
        Intrinsics.checkNotNullParameter((Object)$this$addMaxCustomDurability, (String)"<this>");
        ItemTag itemTag = NMSItemTagKt.getItemTag($this$addMaxCustomDurability);
        ItemTagData itemTagData = ItemUtils.getDeepOrNull(itemTag, "NeigeItems.maxDurability");
        if (itemTagData == null) {
            return;
        }
        int maxDurability = RangesKt.coerceAtLeast((int)(itemTagData.asInt() + amount), (int)1);
        ItemTagData itemTagData2 = ItemUtils.getDeepOrNull(itemTag, "NeigeItems.durability");
        Intrinsics.checkNotNull((Object)itemTagData2);
        int durability = RangesKt.coerceAtMost((int)itemTagData2.asInt(), (int)maxDurability);
        ItemUtils.putDeepFixed(itemTag, "NeigeItems.durability", new ItemTagData(durability));
        ItemUtils.putDeepFixed(itemTag, "NeigeItems.maxDurability", new ItemTagData(maxDurability));
        $this$addMaxCustomDurability.setDurability((short)((double)$this$addMaxCustomDurability.getDurability() * (1.0 - (double)durability / (double)maxDurability)));
        itemTag.saveTo($this$addMaxCustomDurability);
    }

    static {
        INSTANCE.loadItems();
    }
}

