/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.neigeitems.taboolib.library.configuration;

import com.electronwill.nightconfig.core.EnumGetMethod;
import com.electronwill.nightconfig.core.utils.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import pers.neige.neigeitems.taboolib.library.configuration.AdvancedPath;
import pers.neige.neigeitems.taboolib.library.configuration.Conversion;
import pers.neige.neigeitems.taboolib.library.configuration.Converter;
import pers.neige.neigeitems.taboolib.library.configuration.InvalidValueException;
import pers.neige.neigeitems.taboolib.library.configuration.Path;
import pers.neige.neigeitems.taboolib.library.configuration.PreserveNotNull;
import pers.neige.neigeitems.taboolib.library.configuration.ReflectionException;
import pers.neige.neigeitems.taboolib.library.configuration.SpecClassInArray;
import pers.neige.neigeitems.taboolib.library.configuration.SpecDoubleInRange;
import pers.neige.neigeitems.taboolib.library.configuration.SpecEnum;
import pers.neige.neigeitems.taboolib.library.configuration.SpecFloatInRange;
import pers.neige.neigeitems.taboolib.library.configuration.SpecIntInRange;
import pers.neige.neigeitems.taboolib.library.configuration.SpecLongInRange;
import pers.neige.neigeitems.taboolib.library.configuration.SpecNotNull;
import pers.neige.neigeitems.taboolib.library.configuration.SpecStringInArray;
import pers.neige.neigeitems.taboolib.library.configuration.SpecStringInRange;
import pers.neige.neigeitems.taboolib.library.configuration.SpecValidator;

final class AnnotationUtils {
    private AnnotationUtils() {
    }

    static boolean isEnum(Field annotatedElement) {
        return annotatedElement.getType().isEnum() || annotatedElement.isAnnotationPresent(PreserveNotNull.class);
    }

    static boolean hasPreserveNotNull(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(PreserveNotNull.class);
    }

    static boolean mustPreserve(Field field, Class<?> fieldClass) {
        return AnnotationUtils.hasPreserveNotNull(field) || AnnotationUtils.hasPreserveNotNull(fieldClass);
    }

    static Converter<Object, Object> getConverter(Field field) {
        Conversion conversion = field.getAnnotation(Conversion.class);
        if (conversion != null) {
            try {
                Constructor<Converter<?, ?>> constructor2 = conversion.value().getDeclaredConstructor(new Class[0]);
                if (!constructor2.isAccessible()) {
                    constructor2.setAccessible(true);
                }
                return constructor2.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new ReflectionException("Cannot create a converter for field " + field, ex);
            }
        }
        return null;
    }

    static List<String> getPath(Field field) {
        List<String> annotatedPath = AnnotationUtils.getPath((AnnotatedElement)field);
        return annotatedPath == null ? Collections.singletonList(field.getName()) : annotatedPath;
    }

    static List<String> getPath(AnnotatedElement annotatedElement) {
        Path path = annotatedElement.getDeclaredAnnotation(Path.class);
        if (path != null) {
            return StringUtils.split((String)path.value(), (char)'.');
        }
        AdvancedPath advancedPath = annotatedElement.getDeclaredAnnotation(AdvancedPath.class);
        if (advancedPath != null) {
            return Arrays.asList(advancedPath.value());
        }
        return null;
    }

    static void checkField(Field field, Object value2) {
        SpecValidator specValidator;
        SpecEnum specEnum;
        SpecNotNull specNotNull = field.getDeclaredAnnotation(SpecNotNull.class);
        if (specNotNull != null) {
            AnnotationUtils.checkNotNull(field, value2);
            return;
        }
        SpecClassInArray specClassInArray = field.getDeclaredAnnotation(SpecClassInArray.class);
        if (specClassInArray != null) {
            AnnotationUtils.checkFieldSpec(field, value2, specClassInArray);
            return;
        }
        SpecStringInArray specStringInArray = field.getDeclaredAnnotation(SpecStringInArray.class);
        if (specStringInArray != null) {
            AnnotationUtils.checkFieldSpec(field, value2, specStringInArray);
            return;
        }
        SpecStringInRange specStringInRange = field.getDeclaredAnnotation(SpecStringInRange.class);
        if (specStringInRange != null) {
            AnnotationUtils.checkFieldSpec(field, value2, specStringInRange);
            return;
        }
        SpecDoubleInRange specDoubleInRange = field.getDeclaredAnnotation(SpecDoubleInRange.class);
        if (specDoubleInRange != null) {
            AnnotationUtils.checkFieldSpec(field, value2, specDoubleInRange);
            return;
        }
        SpecFloatInRange specFloatInRange = field.getDeclaredAnnotation(SpecFloatInRange.class);
        if (specFloatInRange != null) {
            AnnotationUtils.checkFieldSpec(field, value2, specFloatInRange);
            return;
        }
        SpecLongInRange specLongInRange = field.getDeclaredAnnotation(SpecLongInRange.class);
        if (specLongInRange != null) {
            AnnotationUtils.checkFieldSpec(field, value2, specLongInRange);
            return;
        }
        SpecIntInRange specIntInRange = field.getDeclaredAnnotation(SpecIntInRange.class);
        if (specIntInRange != null) {
            AnnotationUtils.checkFieldSpec(field, value2, specIntInRange);
        }
        if ((specEnum = field.getDeclaredAnnotation(SpecEnum.class)) != null) {
            AnnotationUtils.checkFieldSpec(field, value2, specEnum);
        }
        if ((specValidator = field.getDeclaredAnnotation(SpecValidator.class)) != null) {
            AnnotationUtils.checkFieldSpec(field, value2, specValidator);
        }
    }

    private static void checkFieldSpec(Field field, Object value2, SpecValidator spec) {
        Predicate<Object> validatorInstance;
        try {
            Constructor<? extends Predicate<Object>> constructor2 = spec.value().getDeclaredConstructor(new Class[0]);
            constructor2.setAccessible(true);
            validatorInstance = constructor2.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionException("Cannot create a converter for field " + field, ex);
        }
        if (!validatorInstance.test(value2)) {
            throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value2, field, spec);
        }
    }

    private static void checkFieldSpec(Field field, Object value2, SpecClassInArray spec) {
        AnnotationUtils.checkNotNull(field, value2);
        Class<?> valueClass = value2.getClass();
        if (spec.strict()) {
            for (Class<?> aClass : spec.value()) {
                if (!aClass.isAssignableFrom(valueClass)) continue;
                return;
            }
        } else {
            for (Class<?> aClass : spec.value()) {
                if (!aClass.equals(valueClass)) continue;
                return;
            }
        }
        throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value2, field, spec);
    }

    private static void checkFieldSpec(Field field, Object value2, SpecStringInRange spec) {
        AnnotationUtils.checkClass(field, value2, String.class);
        String s = (String)value2;
        if (s.compareTo(spec.min()) < 0 || s.compareTo(spec.max()) > 0) {
            throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value2, field, spec);
        }
    }

    private static void checkFieldSpec(Field field, Object value2, SpecEnum spec) {
        EnumGetMethod m = spec.method();
        Class<?> fieldType = field.getType();
        if (!fieldType.isEnum()) {
            throw new InvalidValueException("Field %s is annotated with @SpecEnum but isn't of type enum", field);
        }
        Class<?> t = fieldType;
        if (!m.validate(value2, t)) {
            throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value2, field, spec);
        }
    }

    private static void checkFieldSpec(Field field, Object value2, SpecStringInArray spec) {
        AnnotationUtils.checkClass(field, value2, String.class);
        String s = (String)value2;
        if (spec.ignoreCase()) {
            for (String acceptable : spec.value()) {
                if (!s.equalsIgnoreCase(acceptable)) continue;
                return;
            }
        } else {
            for (String acceptable : spec.value()) {
                if (!s.equals(acceptable)) continue;
                return;
            }
        }
        throw new InvalidValueException("Invalid value \"%s\" for field %s: it doesn't conform to %s", value2, field, spec);
    }

    private static void checkFieldSpec(Field field, Object value2, SpecDoubleInRange spec) {
        AnnotationUtils.checkClass(field, value2, Double.class);
        double d = (Double)value2;
        if (d < spec.min() || d > spec.max()) {
            throw new InvalidValueException("Invalid value %f for field %s: it doesn't conform to %s", value2, field, spec);
        }
    }

    private static void checkFieldSpec(Field field, Object value2, SpecFloatInRange spec) {
        AnnotationUtils.checkClass(field, value2, Float.class);
        float d = ((Float)value2).floatValue();
        if (d < spec.min() || d > spec.max()) {
            throw new InvalidValueException("Invalid value %f for field %s: it doesn't conform to %s", value2, field, spec);
        }
    }

    private static void checkFieldSpec(Field field, Object value2, SpecLongInRange spec) {
        AnnotationUtils.checkClass(field, value2, Long.class);
        long d = (Long)value2;
        if (d < spec.min() || d > spec.max()) {
            throw new InvalidValueException("Invalid value %d for field %s: it doesn't conform to %s", value2, field, spec);
        }
    }

    private static void checkFieldSpec(Field field, Object value2, SpecIntInRange spec) {
        AnnotationUtils.checkClass(field, value2, Integer.class);
        int d = (Integer)value2;
        if (d < spec.min() || d > spec.max()) {
            throw new InvalidValueException("Invalid value %d for field %s: it doesn't conform to %s", value2, field, spec);
        }
    }

    private static void checkNotNull(Field field, Object value2) {
        if (value2 == null) {
            throw new InvalidValueException("Invalid null value for field %s", field);
        }
    }

    private static void checkClass(Field field, Object value2, Class<?> expectedClass) {
        AnnotationUtils.checkNotNull(field, value2);
        Class<?> valueClass = value2.getClass();
        if (valueClass != expectedClass) {
            throw new InvalidValueException("Invalid type %s for field %s, expected %s", valueClass, field, expectedClass);
        }
    }
}

