/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.api.group;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Node<O> {
    private O value;
    private final List<Node<O>> children = new ArrayList<Node<O>>();
    private boolean isRoot = false;
    private Node<O> parent;

    public Node() {
        this.isRoot = true;
    }

    public Node(O o) {
        this.value = o;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<Node<O>> getChildren() {
        return this.children;
    }

    public List<O> getChildrenValues() {
        ArrayList arrayList = new ArrayList(this.children.size());
        this.getChildren().forEach(node -> arrayList.add(node.getValue()));
        return arrayList;
    }

    public Node<O> addChildren(O o) {
        if (!this.containsChildren(o)) {
            Node<O> node = new Node<O>(o);
            this.children.add(node);
            node.parent = this;
            return node;
        }
        return this.getChild(o);
    }

    @Nullable
    public Node<O> getChild(O o) {
        for (Node<O> node : this.children) {
            if (!node.getValue().equals(o)) continue;
            return node;
        }
        return null;
    }

    public boolean containsChildren(O o) {
        for (Node<O> node : this.children) {
            if (!node.getValue().equals(o)) continue;
            return true;
        }
        return false;
    }

    public O getValue() {
        return this.value;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    @Nullable
    public Node<O> getParent() {
        return this.parent;
    }
}

