/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.libs.net.byteflux.libby;

import eu.nononitas.plhidepro.libs.net.byteflux.libby.Library;
import eu.nononitas.plhidepro.libs.net.byteflux.libby.classloader.IsolatedClassLoader;
import eu.nononitas.plhidepro.libs.net.byteflux.libby.logging.LogLevel;
import eu.nononitas.plhidepro.libs.net.byteflux.libby.logging.Logger;
import eu.nononitas.plhidepro.libs.net.byteflux.libby.logging.adapters.LogAdapter;
import eu.nononitas.plhidepro.libs.net.byteflux.libby.relocation.Relocation;
import eu.nononitas.plhidepro.libs.net.byteflux.libby.relocation.RelocationHelper;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class LibraryManager {
    protected final Logger logger;
    protected final Path saveDirectory;
    private final Set<String> repositories = new LinkedHashSet<String>();
    private RelocationHelper relocator;
    private final Map<String, IsolatedClassLoader> isolatedLibraries = new HashMap<String, IsolatedClassLoader>();

    @Deprecated
    protected LibraryManager(LogAdapter logAdapter, Path path) {
        this.logger = new Logger(Objects.requireNonNull(logAdapter, "logAdapter"));
        this.saveDirectory = Objects.requireNonNull(path, "dataDirectory").toAbsolutePath().resolve("lib");
    }

    protected LibraryManager(LogAdapter logAdapter, Path path, String string) {
        this.logger = new Logger(Objects.requireNonNull(logAdapter, "logAdapter"));
        this.saveDirectory = Objects.requireNonNull(path, "dataDirectory").toAbsolutePath().resolve(Objects.requireNonNull(string, "directoryName"));
    }

    protected abstract void addToClasspath(Path var1);

    protected void addToIsolatedClasspath(Library library, Path path) {
        String string2 = library.getId();
        IsolatedClassLoader isolatedClassLoader = string2 != null ? this.isolatedLibraries.computeIfAbsent(string2, string -> new IsolatedClassLoader(new URL[0])) : new IsolatedClassLoader(new URL[0]);
        isolatedClassLoader.addPath(path);
    }

    public IsolatedClassLoader getIsolatedClassLoaderOf(String string) {
        return this.isolatedLibraries.get(string);
    }

    public LogLevel getLogLevel() {
        return this.logger.getLevel();
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logger.setLevel(logLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getRepositories() {
        LinkedList<String> linkedList;
        Set<String> set = this.repositories;
        synchronized (set) {
            linkedList = new LinkedList<String>(this.repositories);
        }
        return Collections.unmodifiableList(linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(String string) {
        String string2 = Objects.requireNonNull(string, "url").endsWith("/") ? string : string + '/';
        Set<String> set = this.repositories;
        synchronized (set) {
            this.repositories.add(string2);
        }
    }

    public void addMavenLocal() {
        this.addRepository(Paths.get(System.getProperty("user.home"), new String[0]).resolve(".m2/repository").toUri().toString());
    }

    public void addMavenCentral() {
        this.addRepository("https://repo1.maven.org/maven2/");
    }

    public void addSonatype() {
        this.addRepository("https://oss.sonatype.org/content/groups/public/");
    }

    public void addJCenter() {
        this.addRepository("https://jcenter.bintray.com/");
    }

    public void addJitPack() {
        this.addRepository("https://jitpack.io/");
    }

    public Collection<String> resolveLibrary(Library library) {
        String string;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Objects.requireNonNull(library, "library").getUrls());
        boolean bl = library.isSnapshot();
        for (String string2 : library.getRepositories()) {
            if (bl) {
                string = this.resolveSnapshot(string2, library);
                if (string == null) continue;
                linkedHashSet.add(string2 + string);
                continue;
            }
            linkedHashSet.add(string2 + library.getPath());
        }
        for (String string2 : this.getRepositories()) {
            if (bl) {
                string = this.resolveSnapshot(string2, library);
                if (string == null) continue;
                linkedHashSet.add(string2 + string);
                continue;
            }
            linkedHashSet.add(string2 + library.getPath());
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    private String resolveSnapshot(String string, Library library) {
        String string2;
        block15: {
            String string3 = Objects.requireNonNull(string, "repository") + Objects.requireNonNull(library, "library").getPartialPath() + "maven-metadata.xml";
            URLConnection uRLConnection = new URL(Objects.requireNonNull(string3, "url")).openConnection();
            uRLConnection.setConnectTimeout(5000);
            uRLConnection.setReadTimeout(5000);
            uRLConnection.setRequestProperty("User-Agent", "libby/1.3.0-pre");
            InputStream inputStream = uRLConnection.getInputStream();
            try {
                string2 = this.getURLFromMetadata(inputStream, library);
                if (inputStream == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException(malformedURLException);
                }
                catch (IOException iOException) {
                    if (iOException instanceof FileNotFoundException) {
                        this.logger.debug("File not found: " + string3);
                    } else if (iOException instanceof SocketTimeoutException) {
                        this.logger.debug("Connect timed out: " + string3);
                    } else if (iOException instanceof UnknownHostException) {
                        this.logger.debug("Unknown host: " + string3);
                    } else {
                        this.logger.debug("Unexpected IOException", iOException);
                    }
                    return null;
                }
            }
            inputStream.close();
        }
        return string2;
    }

    private String getURLFromMetadata(InputStream inputStream, Library library) {
        String string;
        String string2;
        Object object;
        Object object2;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(library, "library");
        try {
            object2 = DocumentBuilderFactory.newInstance();
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            Document document = ((DocumentBuilder)object).parse(inputStream);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("snapshot");
            if (nodeList.getLength() == 0) {
                return null;
            }
            Node node = nodeList.item(0);
            if (node.getNodeType() != 1) {
                return null;
            }
            Node node2 = ((Element)node).getElementsByTagName("timestamp").item(0);
            if (node2 == null || node2.getNodeType() != 1) {
                return null;
            }
            Node node3 = ((Element)node).getElementsByTagName("buildNumber").item(0);
            if (node3 == null || node3.getNodeType() != 1) {
                return null;
            }
            Node node4 = node2.getFirstChild();
            if (node4 == null || node4.getNodeType() != 3) {
                return null;
            }
            Node node5 = node3.getFirstChild();
            if (node5 == null || node5.getNodeType() != 3) {
                return null;
            }
            string2 = node4.getNodeValue();
            string = node5.getNodeValue();
        }
        catch (ParserConfigurationException | SAXException exception) {
            this.logger.debug("Invalid maven-metadata.xml", exception);
            return null;
        }
        object2 = library.getVersion();
        if (((String)object2).endsWith("-SNAPSHOT")) {
            object2 = ((String)object2).substring(0, ((String)object2).length() - "-SNAPSHOT".length());
        }
        object = library.getPartialPath() + library.getArtifactId() + '-' + (String)object2 + '-' + string2 + '-' + string;
        if (library.hasClassifier()) {
            object = (String)object + '-' + library.getClassifier();
        }
        return (String)object + ".jar";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] downloadLibrary(String string) {
        try {
            URLConnection uRLConnection = new URL(Objects.requireNonNull(string, "url")).openConnection();
            uRLConnection.setConnectTimeout(5000);
            uRLConnection.setReadTimeout(5000);
            uRLConnection.setRequestProperty("User-Agent", "libby/1.3.0-pre");
            InputStream inputStream = uRLConnection.getInputStream();
            try {
                byte[] byArray2 = new byte[8192];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    int n;
                    while ((n = inputStream.read(byArray2)) != -1) {
                        byteArrayOutputStream.write(byArray2, 0, n);
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.logger.warn("Download timed out: " + uRLConnection.getURL());
                    byte[] byArray3 = null;
                    if (inputStream == null) return byArray3;
                    inputStream.close();
                    return byArray3;
                }
                this.logger.info("Downloaded library " + uRLConnection.getURL());
                byte[] byArray = byteArrayOutputStream.toByteArray();
                return byArray;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable;
                        throwable.addSuppressed(throwable2);
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
        catch (IOException iOException) {
            if (iOException instanceof FileNotFoundException) {
                this.logger.debug("File not found: " + string);
                return null;
            }
            if (iOException instanceof SocketTimeoutException) {
                this.logger.debug("Connect timed out: " + string);
                return null;
            }
            if (iOException instanceof UnknownHostException) {
                this.logger.debug("Unknown host: " + string);
                return null;
            }
            this.logger.debug("Unexpected IOException", iOException);
            return null;
        }
    }

    public Path downloadLibrary(Library library) {
        Collection<String> collection;
        Path path = this.saveDirectory.resolve(Objects.requireNonNull(library, "library").getPath());
        if (Files.exists(path, new LinkOption[0])) {
            if (!library.isSnapshot()) {
                return path;
            }
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
        if ((collection = this.resolveLibrary(library)).isEmpty()) {
            throw new RuntimeException("Library '" + library + "' couldn't be resolved, add a repository");
        }
        MessageDigest messageDigest = null;
        if (library.hasChecksum()) {
            try {
                messageDigest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
        }
        Path path2 = path.resolveSibling(path.getFileName() + ".tmp");
        path2.toFile().deleteOnExit();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            for (String string : collection) {
                Object object;
                byte[] byArray = this.downloadLibrary(string);
                if (byArray == null) continue;
                if (messageDigest != null && !Arrays.equals(object = messageDigest.digest(byArray), library.getChecksum())) {
                    this.logger.warn("*** INVALID CHECKSUM ***");
                    this.logger.warn(" Library :  " + library);
                    this.logger.warn(" URL :  " + string);
                    this.logger.warn(" Expected :  " + Base64.getEncoder().encodeToString(library.getChecksum()));
                    this.logger.warn(" Actual :  " + Base64.getEncoder().encodeToString((byte[])object));
                    continue;
                }
                Files.write(path2, byArray, new OpenOption[0]);
                Files.move(path2, path, new CopyOption[0]);
                object = path;
                return object;
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        finally {
            try {
                Files.deleteIfExists(path2);
            }
            catch (IOException iOException) {}
        }
        throw new RuntimeException("Failed to download library '" + library + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path relocate(Path path, String string, Collection<Relocation> collection) {
        Objects.requireNonNull(path, "in");
        Objects.requireNonNull(string, "out");
        Objects.requireNonNull(collection, "relocations");
        Path path2 = this.saveDirectory.resolve(string);
        if (Files.exists(path2, new LinkOption[0])) {
            return path2;
        }
        Path path3 = path2.resolveSibling(path2.getFileName() + ".tmp");
        path3.toFile().deleteOnExit();
        Object object = this;
        synchronized (object) {
            if (this.relocator == null) {
                this.relocator = new RelocationHelper(this);
            }
        }
        try {
            this.relocator.relocate(path, path3, collection);
            Files.move(path3, path2, new CopyOption[0]);
            this.logger.info("Relocations applied to " + this.saveDirectory.getParent().relativize(path));
            object = path2;
            return object;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        finally {
            try {
                Files.deleteIfExists(path3);
            }
            catch (IOException iOException) {}
        }
    }

    public void loadLibrary(Library library) {
        Path path = this.downloadLibrary(Objects.requireNonNull(library, "library"));
        if (library.hasRelocations()) {
            path = this.relocate(path, library.getRelocatedPath(), library.getRelocations());
        }
        if (library.isIsolatedLoad()) {
            this.addToIsolatedClasspath(library, path);
        } else {
            this.addToClasspath(path);
        }
    }
}

