/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.libs.net.byteflux.libby.classloader;

import eu.nononitas.plhidepro.libs.net.byteflux.libby.Library;
import eu.nononitas.plhidepro.libs.net.byteflux.libby.LibraryManager;
import eu.nononitas.plhidepro.libs.net.byteflux.libby.classloader.IsolatedClassLoader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import sun.misc.Unsafe;

public class URLClassLoaderHelper {
    private static final Unsafe theUnsafe;
    private final URLClassLoader classLoader;
    private MethodHandle addURLMethodHandle = null;

    public URLClassLoaderHelper(URLClassLoader uRLClassLoader, LibraryManager libraryManager) {
        Objects.requireNonNull(libraryManager, "libraryManager");
        this.classLoader = Objects.requireNonNull(uRLClassLoader, "classLoader");
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            try {
                URLClassLoaderHelper.openUrlClassLoaderModule();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                method.setAccessible(true);
            }
            catch (Exception exception) {
                if (exception.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                    if (theUnsafe != null) {
                        try {
                            this.addURLMethodHandle = this.getPrivilegedMethodHandle(method).bindTo(uRLClassLoader);
                            return;
                        }
                        catch (Exception exception2) {
                            this.addURLMethodHandle = null;
                        }
                    }
                    try {
                        this.addOpensWithAgent(libraryManager);
                        method.setAccessible(true);
                    }
                    catch (Exception exception3) {
                        System.err.println("Cannot access URLClassLoader#addURL(URL), if you are using Java 9+ try to add the following option to your java command: --add-opens java.base/java.net=ALL-UNNAMED");
                        throw new RuntimeException("Cannot access URLClassLoader#addURL(URL)", exception3);
                    }
                }
                throw new RuntimeException("Cannot set accessible URLClassLoader#addURL(URL)", exception);
            }
            this.addURLMethodHandle = MethodHandles.lookup().unreflect(method).bindTo(uRLClassLoader);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public void addToClasspath(URL uRL) {
        try {
            this.addURLMethodHandle.invokeWithArguments(Objects.requireNonNull(uRL, "url"));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void addToClasspath(Path path) {
        try {
            this.addToClasspath(Objects.requireNonNull(path, "path").toUri().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    private static void openUrlClassLoaderModule() {
        Class<?> clazz = Class.forName("java.lang.Module");
        Method method = Class.class.getMethod("getModule", new Class[0]);
        Method method2 = clazz.getMethod("addOpens", String.class, clazz);
        Object object = method.invoke(URLClassLoader.class, new Object[0]);
        Object object2 = method.invoke(URLClassLoaderHelper.class, new Object[0]);
        method2.invoke(object, URLClassLoader.class.getPackage().getName(), object2);
    }

    private MethodHandle getPrivilegedMethodHandle(Method method) {
        for (Field field : MethodHandles.Lookup.class.getDeclaredFields()) {
            if (field.getType() != MethodHandles.Lookup.class || !Modifier.isStatic(field.getModifiers()) || field.isSynthetic()) continue;
            try {
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)theUnsafe.getObject(theUnsafe.staticFieldBase(field), theUnsafe.staticFieldOffset(field));
                return lookup.unreflect(method);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException("Cannot get privileged method handle.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOpensWithAgent(LibraryManager libraryManager) {
        IsolatedClassLoader isolatedClassLoader = new IsolatedClassLoader(new URL[0]);
        try {
            isolatedClassLoader.addPath(libraryManager.downloadLibrary(Library.builder().groupId("net.bytebuddy").artifactId("byte-buddy-agent").version("1.12.1").checksum("mcCtBT9cljUEniB5ESpPDYZMfVxEs1JRPllOiWTP+bM=").repository("https://repo1.maven.org/maven2/").build()));
            Class<?> clazz = isolatedClassLoader.loadClass("net.bytebuddy.agent.ByteBuddyAgent");
            Object object = clazz.getDeclaredMethod("install", new Class[0]).invoke(null, new Object[0]);
            Class<?> clazz2 = Class.forName("java.lang.instrument.Instrumentation");
            Method method = clazz2.getDeclaredMethod("redefineModule", Class.forName("java.lang.Module"), Set.class, Map.class, Map.class, Set.class, Map.class);
            Method method2 = Class.class.getDeclaredMethod("getModule", new Class[0]);
            Map<String, Set<Object>> map = Collections.singletonMap("java.net", Collections.singleton(method2.invoke(this.getClass(), new Object[0])));
            method.invoke(object, method2.invoke(URLClassLoader.class, new Object[0]), Collections.emptySet(), Collections.emptyMap(), map, Collections.emptySet(), Collections.emptyMap());
        }
        finally {
            try {
                isolatedClassLoader.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        Unsafe unsafe = null;
        for (Field field : Unsafe.class.getDeclaredFields()) {
            try {
                if (field.getType() != Unsafe.class || !Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                unsafe = (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        theUnsafe = unsafe;
    }
}

