/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.spigot;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketListener;
import com.google.common.io.ByteStreams;
import eu.nononitas.plhidepro.PlHidePro;
import eu.nononitas.plhidepro.PlHideProvider;
import eu.nononitas.plhidepro.libs.org.bstats.bukkit.Metrics;
import eu.nononitas.plhidepro.libs.org.bstats.charts.SimplePie;
import eu.nononitas.plhidepro.libs.org.bstats.charts.SingleLineChart;
import eu.nononitas.plhidepro.miscellaneous.CommandsListManager;
import eu.nononitas.plhidepro.miscellaneous.Database;
import eu.nononitas.plhidepro.miscellaneous.DebugLogger;
import eu.nononitas.plhidepro.miscellaneous.IConfig;
import eu.nononitas.plhidepro.miscellaneous.ILogger;
import eu.nononitas.plhidepro.miscellaneous.LuckPermsListener;
import eu.nononitas.plhidepro.spigot.PlHideCmd;
import eu.nononitas.plhidepro.spigot.SpigotPlugin;
import eu.nononitas.plhidepro.spigot.impl.Config;
import eu.nononitas.plhidepro.spigot.impl.Logger;
import eu.nononitas.plhidepro.spigot.listeners.CommandListener;
import eu.nononitas.plhidepro.spigot.listeners.CommandSuggestionListener;
import eu.nononitas.plhidepro.spigot.listeners.JoinListener;
import eu.nononitas.plhidepro.spigot.listeners.OpListener;
import eu.nononitas.plhidepro.spigot.listeners.TabcompleteListener;
import eu.nononitas.plhidepro.spigot.miscellaneous.ConfigHandler;
import eu.nononitas.plhidepro.spigot.miscellaneous.NMS_Version;
import eu.nononitas.plhidepro.spigot.miscellaneous.PluginMessageHandler;
import eu.nononitas.plhidepro.util.PluginCommandsInfo;
import eu.nononitas.plhidepro.util.Updater;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.Nullable;

public class PlHideProSpigot
implements PlHidePro {
    public static final int CONFIG_VERSION = 13;
    private static PlHideProSpigot instance;
    private final SpigotPlugin plugin;
    private final CommandsListManager listManager = new CommandsListManager(this);
    private final PluginMessageHandler pluginMessageHandler;
    private boolean isLegacy;
    private String brandChannel;
    private DebugLogger debugLogger;
    private NMS_Version nmsVersion;
    private boolean isUsingProxy = false;
    private Database database;
    private OpListener opListener;
    private Logger logger;

    public PlHideProSpigot(SpigotPlugin spigotPlugin) {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
        this.plugin = spigotPlugin;
        this.pluginMessageHandler = new PluginMessageHandler(this);
    }

    public static PlHideProSpigot getInstance() {
        return instance;
    }

    public boolean isIsUsingProxy() {
        return this.isUsingProxy;
    }

    @Nullable
    public String getColoredConfigString(String string) {
        String string2 = this.getPlugin().getConfig().getString(string);
        if (string2 != null) {
            string2 = PlHidePro.translateColor(string2);
        }
        return string2;
    }

    public String getBrandChannel() {
        return this.brandChannel;
    }

    public DebugLogger getDebugLogger() {
        return this.debugLogger;
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }

    private static void setPluginCommandsInfo() {
        Map map;
        Field field;
        SimpleCommandMap simpleCommandMap;
        Field field2;
        try {
            field2 = Class.forName(Bukkit.getServer().getClass().getPackage().getName() + ".CraftServer").getDeclaredField("commandMap");
            field2.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return;
        }
        try {
            simpleCommandMap = (SimpleCommandMap)field2.get(Bukkit.getServer());
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return;
        }
        try {
            field = SimpleCommandMap.class.getDeclaredField("knownCommands");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
            return;
        }
        try {
            map = (Map)field.get(simpleCommandMap);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return;
        }
        map.forEach((string, command) -> {
            if (string.toLowerCase().contains(":")) {
                int n = string.indexOf(":");
                String string2 = string.substring(0, n);
                string = string.substring(n + 1);
                PluginCommandsInfo.addCommand(string2, string);
            }
        });
    }

    public SpigotPlugin getPlugin() {
        return this.plugin;
    }

    void enable() {
        String string = Bukkit.getServer().getBukkitVersion();
        this.nmsVersion = NMS_Version.fromBukkitVersion(string);
        if (this.nmsVersion == NMS_Version.UNSUPPORTED) {
            this.getLogger().warn("The server version " + string + " you are using is currently unsupported");
            this.plugin.getPluginLoader().disablePlugin((Plugin)this.plugin);
            return;
        }
        PlHideProvider.setPlHidePro(this);
        this.isLegacy = NMS_Version.isLegacy(string);
        this.brandChannel = this.isLegacy ? "MC|Brand" : "minecraft:brand";
        Updater.currentVersion = this.plugin.getDescription().getVersion();
        this.createConfig();
        this.plugin.reloadConfig();
        this.debugLogger = new DebugLogger(this.plugin.getDataFolder().getPath(), this.plugin.getConfig().getBoolean("debug"));
        this.logger = new Logger(this.plugin.getLogger(), this.debugLogger);
        this.updateConfig();
        this.listManager.loadLists();
        this.checkGroups();
        this.database = new Database(this.getDataFolder().toPath(), this);
        if (!ProtocolLibrary.getPlugin().getDescription().getVersion().startsWith("5.")) {
            this.getLogger().error("Incompatible ProtocolLib version detected. Please use version 5.x");
            this.plugin.getPluginLoader().disablePlugin((Plugin)this.plugin);
            return;
        }
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new TabcompleteListener(this, ListenerPriority.HIGHEST, Arrays.asList(PacketType.Play.Server.TAB_COMPLETE, PacketType.Play.Client.TAB_COMPLETE), ListenerOptions.ASYNC));
        if (!this.isLegacy()) {
            ProtocolLibrary.getProtocolManager().getAsynchronousManager().registerAsyncHandler((PacketListener)new CommandSuggestionListener(this)).start();
        }
        this.initListeners();
        this.plugin.getCommand("plhide").setExecutor((CommandExecutor)new PlHideCmd(this));
        this.plugin.getCommand("plhide").setTabCompleter((TabCompleter)new PlHideCmd(this));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Optional<String> optional = Updater.updatecheck(false);
            optional.ifPresent(string -> this.getLogger().info((String)string));
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Metrics metrics = new Metrics(this.plugin, 5014);
                metrics.addCustomChart(new SingleLineChart("players", () -> Bukkit.getOnlinePlayers().size()));
                metrics.addCustomChart(new SingleLineChart("servers", () -> 1));
                metrics.addCustomChart(new SimplePie("op-protection", () -> String.valueOf(this.plugin.getConfig().getBoolean("op-protection"))));
                metrics.addCustomChart(new SimplePie("update-notify", () -> String.valueOf(this.plugin.getConfig().getBoolean("update-notify"))));
            });
        });
        try {
            Method method = this.plugin.getServer().getMessenger().getClass().getDeclaredMethod("addToOutgoing", Plugin.class, String.class);
            method.setAccessible(true);
            method.invoke((Object)this.plugin.getServer().getMessenger(), new Object[]{this.plugin, this.getBrandChannel()});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            this.getLogger().error("Failed to register brand channel");
            reflectiveOperationException.printStackTrace();
        }
        if (this.plugin.getConfig().getBoolean("proxy-mode", false)) {
            this.isUsingProxy = true;
            this.plugin.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, "plhidepro:tab");
            this.plugin.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, "plhidepro:tab", (PluginMessageListener)this.pluginMessageHandler);
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            PlHideProSpigot.setPluginCommandsInfo();
            if (this.isUsingProxy) {
                this.pluginMessageHandler.startPluginCommandsTask();
            }
        });
        if (Bukkit.getPluginManager().getPlugin("LuckPerms") != null) {
            LuckPermsListener.init((Object)this.plugin);
        }
    }

    void disable() {
        if (this.debugLogger != null) {
            this.debugLogger.close();
        }
        this.pluginMessageHandler.disableTask();
        this.database.closeConnection();
    }

    public NMS_Version getNMS_Version() {
        return this.nmsVersion;
    }

    private void initListeners() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new JoinListener(this), (Plugin)this.plugin);
        pluginManager.registerEvents((Listener)new CommandListener(this), (Plugin)this.plugin);
        pluginManager.registerEvents((Listener)new OpListener(this), (Plugin)this.plugin);
        this.opListener = new OpListener(this);
        this.opListener.startOpChecker();
    }

    void createConfig() {
        File file = new File(this.plugin.getDataFolder(), "config.yml");
        if (!file.exists()) {
            this.plugin.saveDefaultConfig();
        }
    }

    private void updateConfig() {
        FileOutputStream fileOutputStream;
        InputStream inputStream;
        int n = this.plugin.getConfig().getInt("version");
        int n2 = 13;
        ILogger iLogger = this.getLogger();
        File file = this.plugin.getDataFolder();
        File file2 = new File(file, "backups");
        File file3 = new File(this.plugin.getDataFolder(), "config_with_explanations.yml");
        try {
            inputStream = this.plugin.getResource("config.yml");
            try {
                fileOutputStream = new FileOutputStream(file3);
                try {
                    file3.createNewFile();
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (n < n2) {
            file2.mkdir();
            try {
                iLogger.warn("\u00a73Pl\u00a77-\u00a73Hide\u00a77-\u00a76Pro \u00a78\u258e \u00a7r\u00a7eNew config version available. Creating backup with the name \u00a7cconfig-old-" + n + ".yml in the backups folder");
                Files.copy(Paths.get(file + "/config.yml", new String[0]), Paths.get(file2 + "/config-old-" + n + ".yml", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            inputStream = this.plugin.getConfig();
            while (n < n2) {
                switch (n) {
                    case 9: {
                        inputStream.set("block-plugin-named-commands-tabcomplete", null);
                        inputStream.set("block-plugin-named-commands-execution", null);
                        fileOutputStream = inputStream.getConfigurationSection("groups");
                        for (Object object : fileOutputStream.getKeys(false)) {
                            fileOutputStream.set((String)object + ".group-mode-commands", null);
                            fileOutputStream.set((String)object + ".group-mode-tabcomplete", null);
                        }
                        break;
                    }
                    case 10: {
                        fileOutputStream = inputStream.getConfigurationSection("groups");
                        for (Object object : fileOutputStream.getKeys(false)) {
                            fileOutputStream.set((String)object + ".inherited-groups", fileOutputStream.getList((String)object + ".included-groups"));
                            fileOutputStream.set((String)object + ".included-groups", null);
                        }
                        break;
                    }
                    case 11: {
                        boolean bl = inputStream.getBoolean("bungee-mode");
                        inputStream.set("bungee-mode", null);
                        inputStream.set("proxy-mode", bl);
                        inputStream.set("ip", null);
                        inputStream.set("port", null);
                        break;
                    }
                    case 12: {
                        Object object;
                        inputStream.set("auto_lowercase_base_commands", true);
                        object = Paths.get(this.getDataFolder().toPath().resolve("lists.yml").toUri());
                        Path path = this.getDataFolder().toPath().resolve("lists");
                        path.toFile().mkdirs();
                        Path path2 = Paths.get(path.resolve("lists.yml").toUri());
                        try {
                            Files.move((Path)object, path2, StandardCopyOption.REPLACE_EXISTING);
                            break;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            this.getLogger().error("Automatically migrating the lists.yml failed. Please move the lists.yml manually into the lists folder!");
                        }
                    }
                }
                inputStream.set("version", ++n);
                this.plugin.saveConfig();
            }
        }
    }

    public boolean checkGroups() {
        ConfigurationSection configurationSection = this.getPlugin().getConfig().getConfigurationSection("groups");
        ILogger iLogger = this.getLogger();
        boolean bl = true;
        if (!configurationSection.isSet("default")) {
            iLogger.error("default group is missing");
            bl = false;
        }
        for (String string : configurationSection.getKeys(false)) {
            if (!configurationSection.isSet(string + ".commands")) {
                iLogger.error("The list commands is missing for the group " + string);
                bl = false;
            }
            if (!configurationSection.isSet(string + ".tabcomplete")) {
                iLogger.error("The list tabcomplete is missing for the group " + string);
                bl = false;
            }
            if (!configurationSection.isSet(string + ".priority")) {
                iLogger.error("The option priority is missing for the group " + string);
                bl = false;
            }
            if (!configurationSection.isSet(string + ".blocked-command-message")) {
                iLogger.error("The option blocked-command-message is missing for the group " + string);
                bl = false;
            }
            if (configurationSection.isSet(string + ".inherited-groups")) continue;
            iLogger.error("The option inherited-groups is missing for the group " + string);
            bl = false;
        }
        return bl;
    }

    public PluginMessageHandler getPluginMessageHandler() {
        return this.pluginMessageHandler;
    }

    @Override
    public ILogger getLogger() {
        return this.logger;
    }

    @Override
    public IConfig getConfig() {
        return new Config((ConfigurationSection)this.getPlugin().getConfig());
    }

    @Override
    public IConfig getConfig(File file) {
        ConfigHandler configHandler = new ConfigHandler(file, this);
        return new Config((ConfigurationSection)configHandler.getConfiguration());
    }

    public OpListener getOpListener() {
        return this.opListener;
    }

    @Override
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    public CommandsListManager getListManager() {
        return this.listManager;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }
}

