/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.spigot.impl;

import eu.nononitas.plhidepro.api.player.PlHidePlayer;
import eu.nononitas.plhidepro.group.Group;
import eu.nononitas.plhidepro.spigot.PlHideProSpigot;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class SpigotGroup
extends Group {
    private final FileConfiguration config;
    private final PlHideProSpigot plHide;

    private SpigotGroup(List<String> list, PlHideProSpigot plHideProSpigot) {
        super(plHideProSpigot);
        this.plHide = plHideProSpigot;
        this.groupNameList = list;
        this.config = plHideProSpigot.getPlugin().getConfig();
        this.isLegacy = plHideProSpigot.isLegacy();
        if (this.isLegacy) {
            this.getTabcompleteList().replaceAll(string -> "/" + string);
        }
    }

    public static SpigotGroup getGroup(PlHidePlayer plHidePlayer, PlHideProSpigot plHideProSpigot) {
        Player player = (Player)plHidePlayer.getHandle();
        ArrayList<String> arrayList = new ArrayList<String>();
        FileConfiguration fileConfiguration = plHideProSpigot.getPlugin().getConfig();
        ConfigurationSection configurationSection = fileConfiguration.getConfigurationSection("groups");
        if (player.isOp() && configurationSection.isSet("op")) {
            arrayList.add("op");
        } else if (player.hasPermission("*") && configurationSection.isSet("*")) {
            arrayList.add("*");
        } else {
            int n = 0;
            for (String string : configurationSection.getKeys(false)) {
                if (!player.hasPermission("plhide.group." + string)) continue;
                int n2 = fileConfiguration.getInt("groups." + string + ".priority");
                if (n2 > n) {
                    n = n2;
                    arrayList.clear();
                    arrayList.add(string);
                    continue;
                }
                if (n2 != n) continue;
                arrayList.add(string);
            }
            if (arrayList.isEmpty()) {
                arrayList.add("default");
            }
        }
        return new SpigotGroup(arrayList, plHideProSpigot);
    }

    @Override
    protected List<String> getConfigList(Group.Type type) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.groupNameList) {
            arrayList.addAll(this.config.getStringList("groups." + string2 + "." + type.toString().toLowerCase()));
            this.getInheritedGroups().forEach(string -> arrayList.addAll(this.config.getStringList("groups." + string + "." + type.toString().toLowerCase())));
            this.replacePluginAndList(arrayList);
        }
        return arrayList.stream().distinct().collect(Collectors.toList());
    }

    @Override
    protected List<String> getInheritedGroups(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.groupNameList) {
            if (list.contains(string2)) continue;
            list.add(string2);
            arrayList.add(string2);
            this.config.getStringList("groups." + string2 + ".inherited-groups").forEach(string -> {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add((String)string);
                arrayList.addAll(new SpigotGroup(arrayList, this.plHide).getInheritedGroups(list));
            });
        }
        return arrayList;
    }
}

