/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.spigot.listeners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.temporary.TemporaryPlayer;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.mojang.brigadier.tree.RootCommandNode;
import eu.nononitas.plhidepro.api.player.PlHidePlayer;
import eu.nononitas.plhidepro.modifier.SuggestionEditor;
import eu.nononitas.plhidepro.spigot.PlHideProSpigot;
import eu.nononitas.plhidepro.spigot.handler.CommandSuggestionPacketHandler;
import eu.nononitas.plhidepro.spigot.impl.CommandSuggestionV1_19_R1;
import eu.nononitas.plhidepro.spigot.impl.CommandSuggestionV1_19_R2;
import eu.nononitas.plhidepro.spigot.listeners.JoinListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandSuggestionListener
extends PacketAdapter {
    private CommandSuggestionPacketHandler handler;
    private final PlHideProSpigot plhide;

    public CommandSuggestionListener(PlHideProSpigot plHideProSpigot) {
        super((Plugin)plHideProSpigot.getPlugin(), ListenerPriority.HIGH, Collections.singletonList(PacketType.Play.Server.COMMANDS), new ListenerOptions[]{ListenerOptions.ASYNC});
        this.plhide = plHideProSpigot;
        switch (plHideProSpigot.getNMS_Version()) {
            case V1_19_R1: {
                this.handler = new CommandSuggestionV1_19_R1();
                break;
            }
            case V1_19_R2: 
            case V1_19_R3: 
            case V1_20_R1: 
            case V1_20_R2: 
            case V1_20_R3: {
                this.handler = new CommandSuggestionV1_19_R2();
                break;
            }
            case UNSUPPORTED: {
                throw new IllegalStateException("Pl-Hide is initialized although it's running on an unsupported version");
            }
        }
    }

    public void onPacketSending(PacketEvent packetEvent) {
        if (this.plhide.isIsUsingProxy()) {
            return;
        }
        Player player = packetEvent.getPlayer();
        if (player == null || player instanceof TemporaryPlayer) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plhide.getPlugin(), () -> {
                Iterator<UUID> iterator = JoinListener.pendingLoginPlayerList.iterator();
                while (iterator.hasNext()) {
                    UUID uUID = iterator.next();
                    Player player = Bukkit.getServer().getPlayer(uUID);
                    if (player != null) {
                        player.updateCommands();
                    }
                    iterator.remove();
                }
            }, 4L);
            packetEvent.setCancelled(true);
            return;
        }
        JoinListener.pendingLoginPlayerList.remove(player.getUniqueId());
        if (!this.plhide.getPlayerManager().isRegistered(player)) {
            packetEvent.setCancelled(true);
            this.plhide.getPlugin().getLogger().warning(String.format("Received a commands suggestion request from %s even though he is not registered. Aborting request", player.getName()));
            return;
        }
        Object PlHPlayer = this.plhide.getPlayerManager().getPlHidePlayer(player);
        switch (this.plhide.getNMS_Version()) {
            case V1_17_AND_LOWER: 
            case V1_18: {
                RootCommandNode rootCommandNode;
                PacketContainer packetContainer = packetEvent.getPacket();
                try {
                    rootCommandNode = (RootCommandNode)packetContainer.getModifier().read(0);
                }
                catch (FieldAccessException fieldAccessException) {
                    fieldAccessException.printStackTrace();
                    break;
                }
                SuggestionEditor.editSuggestion(rootCommandNode, PlHPlayer);
                packetContainer.getModifier().write(0, (Object)rootCommandNode);
                break;
            }
            default: {
                packetEvent.setPacket(new PacketContainer(PacketType.Play.Server.COMMANDS, this.handler.getModifiedPacket(packetEvent.getPacket().getHandle(), (PlHidePlayer)PlHPlayer)));
            }
        }
    }
}

