/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.spigot.listeners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.temporary.TemporaryPlayer;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import eu.nononitas.plhidepro.api.player.PlHidePlayer;
import eu.nononitas.plhidepro.modifier.TabCompleteEditor;
import eu.nononitas.plhidepro.spigot.PlHideProSpigot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TabcompleteListener
extends PacketAdapter {
    private final HashMap<UUID, String> incomingCommand = new HashMap();
    private final PlHideProSpigot plhide;

    public TabcompleteListener(PlHideProSpigot plHideProSpigot, ListenerPriority listenerPriority, Iterable<? extends PacketType> iterable, ListenerOptions ... listenerOptionsArray) {
        super((Plugin)plHideProSpigot.getPlugin(), listenerPriority, iterable, listenerOptionsArray);
        this.plhide = plHideProSpigot;
    }

    public void onPacketReceiving(PacketEvent packetEvent) {
        if (packetEvent.getPacketType() == PacketType.Play.Client.TAB_COMPLETE) {
            if (this.plhide.isIsUsingProxy()) {
                return;
            }
            if (packetEvent.getPlayer() == null) {
                this.plhide.getLogger().debug("Failed to read tabcomplete receive: Player is null");
                packetEvent.setCancelled(true);
                return;
            }
            if (packetEvent.getPlayer() instanceof TemporaryPlayer) {
                this.plhide.getLogger().debug("Failed to read tabcomplete receive: Player is temporary");
                packetEvent.setCancelled(true);
                return;
            }
            if (this.plhide.isLegacy()) {
                this.incomingCommand.put(packetEvent.getPlayer().getUniqueId(), ((String)packetEvent.getPacket().getSpecificModifier(String.class).read(0)).toLowerCase());
            } else {
                this.incomingCommand.put(packetEvent.getPlayer().getUniqueId(), packetEvent.getPacket().getModifier().read(1).toString().toLowerCase());
            }
        }
    }

    public void onPacketSending(PacketEvent packetEvent) {
        if (this.plhide.isIsUsingProxy()) {
            return;
        }
        if (packetEvent.getPlayer() == null) {
            this.plhide.getLogger().debug("Failed to edit tabcomplete send: Player is null");
            packetEvent.setCancelled(true);
            return;
        }
        PacketContainer packetContainer = packetEvent.getPacket();
        if (packetEvent.getPacketType() == PacketType.Play.Server.TAB_COMPLETE) {
            Player player = packetEvent.getPlayer();
            if (!this.plhide.getPlayerManager().isRegistered(player)) {
                packetEvent.setCancelled(true);
                this.plhide.getLogger().warn(String.format("Received a tabcompletion request from %s even though he is not registered. Aborting completion", player.getName()));
                return;
            }
            Object PlHPlayer = this.plhide.getPlayerManager().getPlHidePlayer(player);
            String string2 = this.incomingCommand.getOrDefault(player.getUniqueId(), "");
            if (string2.isEmpty()) {
                packetEvent.setCancelled(true);
                return;
            }
            if (this.plhide.isLegacy()) {
                if (!string2.startsWith("/")) {
                    return;
                }
                String[] stringArray = (String[])packetContainer.getSpecificModifier(String[].class).read(0);
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
                TabCompleteEditor tabCompleteEditor = new TabCompleteEditor((PlHidePlayer)PlHPlayer, string2, (List<String>)arrayList);
                tabCompleteEditor.setLegacyCompletion().change();
                stringArray = new String[arrayList.size()];
                stringArray = arrayList.toArray(stringArray);
                packetContainer.getSpecificModifier(String[].class).write(0, (Object)stringArray);
            } else {
                if (string2.length() < 2) {
                    packetEvent.setCancelled(true);
                    return;
                }
                boolean bl = !string2.startsWith("/");
                string2 = string2.substring(1);
                StringRange stringRange = new StringRange(string2.lastIndexOf(" ") + 2, string2.length() + 1);
                Suggestions suggestions = (Suggestions)packetContainer.getModifier().read(1);
                List list = suggestions.getList();
                ArrayList<String> arrayList = new ArrayList<String>();
                list.forEach(suggestion -> arrayList.add(suggestion.getText()));
                TabCompleteEditor tabCompleteEditor = new TabCompleteEditor((PlHidePlayer)PlHPlayer, string2, (List<String>)arrayList);
                if (bl) {
                    tabCompleteEditor.setLegacyCompletion();
                }
                tabCompleteEditor.change();
                list.clear();
                arrayList.forEach(string -> list.add(new Suggestion(stringRange, string)));
                if (list.isEmpty()) {
                    packetEvent.setCancelled(true);
                }
                packetContainer.getModifier().write(1, (Object)new Suggestions(stringRange, list));
            }
        }
    }
}

