/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;

public final class ByteBufSerializer {
    public static byte[] getByteArray(String string) {
        ByteBuf byteBuf = Unpooled.buffer((int)(string.getBytes(StandardCharsets.UTF_8).length + 1));
        ByteBufSerializer.writeString(byteBuf, string);
        byte[] byArray = byteBuf.array();
        byteBuf.release();
        return byArray;
    }

    private static void writeString(ByteBuf byteBuf, String string) {
        if (string.length() > Short.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Cannot send string longer than 32767 (got %s characters)", string.length()));
        }
        ByteBufSerializer.writeVarInt(byteBuf, string.getBytes(StandardCharsets.UTF_8).length);
        byteBuf.writeBytes(string.getBytes(StandardCharsets.UTF_8));
    }

    private static void writeVarInt(ByteBuf byteBuf, int n) {
        do {
            int n2 = n & 0x7F;
            if ((n >>>= 7) != 0) {
                n2 |= 0x80;
            }
            byteBuf.writeByte(n2);
        } while (n != 0);
    }
}

