/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.velocity.impl;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import eu.nononitas.plhidepro.PlHidePro;
import eu.nononitas.plhidepro.PlHideProxyPlayer;
import eu.nononitas.plhidepro.api.event.EventManager;
import eu.nononitas.plhidepro.api.event.SetGroupEvent;
import eu.nononitas.plhidepro.api.group.GroupMode;
import eu.nononitas.plhidepro.api.group.IGroup;
import eu.nononitas.plhidepro.group.Group;
import eu.nononitas.plhidepro.group.ProxyGroup;
import eu.nononitas.plhidepro.velocity.PlHideProVelocity;
import eu.nononitas.plhidepro.velocity.miscellaneous.LuckPermsPermissionCheck;
import java.util.Optional;

public class PlHideVelocityPlayer
implements PlHideProxyPlayer {
    private final Player player;
    private final PlHidePro plHide;
    private Group group;
    private final boolean hasLuckPerms = PlHideProVelocity.getInstance().hasLuckPerms();
    private LuckPermsPermissionCheck luckPermsPermissionCheck;

    public PlHideVelocityPlayer(Player player, PlHidePro plHidePro) {
        this.player = player;
        this.plHide = plHidePro;
        if (this.hasLuckPerms) {
            this.luckPermsPermissionCheck = new LuckPermsPermissionCheck(player);
        }
        this.updateGroup();
    }

    @Override
    public <P> P getHandle() {
        return (P)this.player;
    }

    @Override
    public IGroup getGroup() {
        return this.group;
    }

    @Override
    public void updateGroup() {
        EventManager eventManager = PlHideProVelocity.getInstance().getEventManager();
        SetGroupEvent setGroupEvent = new SetGroupEvent(this, ProxyGroup.getGroup(this, this.plHide));
        eventManager.executeEvent(setGroupEvent);
        this.group = (Group)setGroupEvent.getGroup();
        if (!this.isLegacy()) {
            PlHideProVelocity.getInstance().getPluginMessageHandler().requestTabcompletions(this.player);
        }
    }

    @Override
    public GroupMode getGroupModeCommands() {
        return this.hasPermission("plhide.blacklist.commands") ? GroupMode.BLACKLIST : GroupMode.WHITELIST;
    }

    @Override
    public GroupMode getGroupModeTabcomplete() {
        return this.hasPermission("plhide.blacklist.tabcomplete") ? GroupMode.BLACKLIST : GroupMode.WHITELIST;
    }

    @Override
    public boolean unblockPluginNamedCommandsExecution() {
        return this.hasPermission("plhide.unblock-plugin-named-commands.execution");
    }

    @Override
    public boolean unblockPluginNamedCommandsTabcomplete() {
        return this.hasPermission("plhide.unblock-plugin-named-commands.tabcomplete");
    }

    @Override
    public boolean hasPermission(String string) {
        if (!this.hasLuckPerms) {
            return this.player.hasPermission(string);
        }
        return this.luckPermsPermissionCheck.hasPermission(string);
    }

    @Override
    public boolean isLegacy() {
        return this.player.getProtocolVersion().getProtocol() < 393;
    }

    @Override
    public String getServerName() {
        Optional optional = this.player.getCurrentServer();
        String string = !optional.isPresent() ? PlHideProVelocity.getInstance().getPlayerCurrentServerMap().get(this.player.getUniqueId()) : ((ServerConnection)optional.get()).getServerInfo().getName();
        return string;
    }
}

