/*
 * Decompiled with CFR 0.152.
 */
package eu.nononitas.plhidepro.velocity.miscellaneous;

import com.google.common.io.ByteStreams;
import eu.nononitas.plhidepro.PlHidePro;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.yaml.YAMLConfigurationLoader;

public class ConfigHandler {
    private final File file;
    private YAMLConfigurationLoader loader;
    private ConfigurationNode configuration;

    public ConfigHandler(File file) {
        this.file = file;
    }

    public void createFile() {
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void createDefaultFile(String string) {
        this.createFile();
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
             FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void save() {
        try {
            this.loader.save(this.configuration);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void load() {
        try {
            this.loader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(this.file.toPath())).build();
            this.configuration = this.loader.load();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Nullable
    public TextComponent getColorTranslatedTextComponent(String ... stringArray) {
        String string = this.configuration.getNode((Object[])stringArray).getString();
        if (string == null) {
            return null;
        }
        return LegacyComponentSerializer.legacySection().deserialize(PlHidePro.translateColor(string));
    }

    @Nullable
    public String getColorTranslatedString(String ... stringArray) {
        String string = this.configuration.getNode((Object[])stringArray).getString();
        if (string == null) {
            return null;
        }
        return PlHidePro.translateColor(string);
    }

    public ConfigurationNode getConfiguration() {
        return this.configuration;
    }
}

