/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.admin;

import com.handy.guild.enter.GuildInfo;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminCreateCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "adminCreate";
    }

    @Override
    public String permission() {
        return "playerGuild.adminCreate";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Player player;
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        String guildName = args[1];
        if (args.length > 2) {
            Optional<Player> onlinePlayer = BaseUtil.getOnlinePlayer(args[2]);
            String onlinePlayerMsg = StrUtil.replace(BaseUtil.getMsgNotColor("onlinePlayerMsg"), "player", args[2]);
            AssertUtil.notTrue(!onlinePlayer.isPresent(), sender, onlinePlayerMsg);
            player = onlinePlayer.get();
        } else {
            player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        }
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findByGuildName(guildName);
        if (guildInfoOptional.isPresent()) {
            MessageUtil.sendMessage(sender, ConfigUtil.CREATE_CONFIG.getString("duplicateName"));
            return;
        }
        GuildUtil.callGuildCreateEvent(player, guildName);
    }
}

