/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.admin;

import com.handy.guild.constants.GuildActivityType;
import com.handy.guild.enter.GuildPvpLocation;
import com.handy.guild.enter.GuildSpawnPvpLocation;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildPvpLocationService;
import com.handy.guild.service.GuildSpawnPvpLocationService;
import com.handy.guild.util.ConfigUtil;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetLocationCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "setLocation";
    }

    @Override
    public String permission() {
        return "playerGuild.setLocation";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        int id;
        AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        GuildActivityType activityType = GuildActivityType.getType(args[1]);
        AssertUtil.notNull((Object)activityType, sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
        String type = activityType.getType();
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        String name = args[2];
        String spawnName = args[3];
        Location location = player.getLocation();
        Optional<GuildPvpLocation> guildPvpLocationOptional = GuildPvpLocationService.getInstance().findByNameAndType(name, type);
        if (!guildPvpLocationOptional.isPresent()) {
            GuildPvpLocation guildPvpLocation = new GuildPvpLocation();
            guildPvpLocation.setName(name);
            guildPvpLocation.setType(type);
            id = GuildPvpLocationService.getInstance().add(guildPvpLocation);
        } else {
            id = guildPvpLocationOptional.get().getId();
        }
        GuildSpawnPvpLocation guildSpawnPvpLocation = new GuildSpawnPvpLocation();
        guildSpawnPvpLocation.setGuildPvpLocationId(id);
        guildSpawnPvpLocation.setSpawnName(spawnName);
        guildSpawnPvpLocation.setX(location.getX());
        guildSpawnPvpLocation.setY(location.getY());
        guildSpawnPvpLocation.setZ(location.getZ());
        guildSpawnPvpLocation.setYaw(location.getYaw());
        guildSpawnPvpLocation.setPitch(location.getPitch());
        guildSpawnPvpLocation.setWorld(location.getWorld() != null ? location.getWorld().getName() : null);
        GuildSpawnPvpLocationService.getInstance().add(guildSpawnPvpLocation);
        String pvpLocation = ConfigUtil.PVP_LOCATION_CONFIG.getString("pvpLocation", "${name}");
        MessageUtil.sendMessage(player, pvpLocation.replace("${name}", name).replace("${spawnName}", spawnName));
    }
}

