/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.function;

import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildPlayerSignIn;
import com.handy.guild.hook.PlayerPointsUtil;
import com.handy.guild.hook.VaultUtil;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildPlayerSignInService;
import com.handy.guild.util.ConfigUtil;
import java.util.Date;
import java.util.Optional;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class SignInCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "signIn";
    }

    @Override
    public String permission() {
        return "playerGuild.signIn";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        Optional<GuildPlayer> guildPlayerOptional;
        OfflinePlayer offlinePlayer;
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        if (args.length == 3) {
            offlinePlayer = BaseUtil.getOfflinePlayer(args[2]);
            if (offlinePlayer == null) {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
                return;
            }
        } else {
            offlinePlayer = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        }
        if (!(guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(offlinePlayer.getName())).isPresent()) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noGuildMsg"));
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        Optional<GuildPlayerSignIn> guildPlayerSignInOptional = GuildPlayerSignInService.getInstance().findByPlayerName(offlinePlayer.getName());
        if (guildPlayerSignInOptional.isPresent()) {
            MessageUtil.sendMessage(sender, ConfigUtil.SIGN_IN_CONFIG.getString("signedInButton"));
            return;
        }
        boolean rst = false;
        int money = 0;
        switch (args[1]) {
            case "vault": {
                int vaultPrice = ConfigUtil.SIGN_IN_CONFIG.getInt("vault.price");
                rst = VaultUtil.buy(offlinePlayer, vaultPrice);
                money = ConfigUtil.SIGN_IN_CONFIG.getInt("vault.money");
                break;
            }
            case "point": {
                int pointPrice = ConfigUtil.SIGN_IN_CONFIG.getInt("point.price");
                rst = PlayerPointsUtil.buy(offlinePlayer.getUniqueId(), pointPrice);
                money = ConfigUtil.SIGN_IN_CONFIG.getInt("point.money");
                break;
            }
        }
        if (!rst) {
            MessageUtil.sendMessage(sender, ConfigUtil.SIGN_IN_CONFIG.getString("notMoneyFailureMsg"));
            return;
        }
        GuildPlayerSignIn signIn = new GuildPlayerSignIn();
        signIn.setGuildInfoId(guildPlayer.getGuildInfoId());
        signIn.setPlayerName(offlinePlayer.getName());
        signIn.setPlayerUuid(offlinePlayer.getUniqueId().toString());
        signIn.setSignInTime(new Date());
        int signInId = GuildPlayerSignInService.getInstance().add(signIn);
        if (signInId > 0) {
            String succeedMsg = ConfigUtil.SIGN_IN_CONFIG.getString("succeedMsg", "").replace("${money}", money + "");
            MessageUtil.sendMessage(sender, succeedMsg);
            GuildPlayerService.getInstance().addMoneyById(guildPlayer.getId(), money);
        } else {
            MessageUtil.sendMessage(sender, ConfigUtil.SIGN_IN_CONFIG.getString("failureMsg"));
        }
    }
}

