/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.MatchConstants;
import com.handy.guild.enter.GuildPvp;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.expand.adapter.HandyRunnable;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.service.GuildPvpLogService;
import com.handy.guild.service.GuildPvpService;
import com.handy.guild.util.ConfigUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class GuildActivityGui {
    private static final GuildActivityGui INSTANCE = new GuildActivityGui();

    private GuildActivityGui() {
    }

    public static GuildActivityGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.ACTIVITY_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.ACTIVITY_CONFIG.getInt("size", 27);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_ACTIVITY.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_ACTIVITY.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Optional<GuildPvp> guildPvpOptional = GuildPvpService.getInstance().findByGuildInfoId(handyInventory.getId());
        HandyInventoryUtil.setButton(ConfigUtil.ACTIVITY_CONFIG, inventory, "seasonPvp", this.replaceMap(guildPvpOptional.orElse(null)));
        HandyInventoryUtil.setButton(ConfigUtil.ACTIVITY_CONFIG, inventory, "matePvp", this.matePvpReplaceMap(handyInventory.getId()));
        HandyInventoryUtil.setButton(ConfigUtil.ACTIVITY_CONFIG, inventory, "back");
    }

    private Map<String, String> replaceMap(GuildPvp guildPvp) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(2);
        String button = ConfigUtil.ACTIVITY_CONFIG.getString("yesButton");
        String join = ConfigUtil.ACTIVITY_CONFIG.getString("joinButton");
        String noButton = ConfigUtil.ACTIVITY_CONFIG.getString("noButton");
        if (guildPvp != null) {
            button = guildPvp.getIsJoin() != false ? join : noButton;
        } else {
            int startDate = ConfigUtil.ACTIVITY_CONFIG.getInt("seasonPvp.startDate");
            Integer todayWeek = DateUtil.dayOfWeekEnum(new Date());
            if (todayWeek == startDate) {
                button = ConfigUtil.ACTIVITY_CONFIG.getString("stopButton");
            }
        }
        replaceMap.put("number", GuildPvpService.getInstance().findSeason().toString());
        replaceMap.put("button", button);
        return replaceMap;
    }

    private Map<String, String> matePvpReplaceMap(Integer guildInfoId) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(2);
        String button = ConfigUtil.ACTIVITY_CONFIG.getString("yesButton");
        String mateButton = ConfigUtil.ACTIVITY_CONFIG.getString("mateButton");
        int count = GuildPvpLogService.getInstance().findByGuildInfoIdAndStartTime(guildInfoId, DateUtil.getToday());
        int number = ConfigUtil.ACTIVITY_CONFIG.getInt("matePvp.number") - count;
        boolean unlimited = ConfigUtil.ACTIVITY_CONFIG.getBoolean("matePvp.unlimited");
        if (number < 1 && !unlimited) {
            button = ConfigUtil.ACTIVITY_CONFIG.getString("stopButton");
        }
        if (number < 1) {
            number = 0;
        }
        replaceMap.put("number", String.valueOf(number));
        if (MatchConstants.GUILD_PVP_PREPARATION_MAP.get(guildInfoId) != null || MatchConstants.GUILD_PVP_START_PLAYER_MAP.get(guildInfoId) != null) {
            String matePvpAcceptPrepareMsg = ConfigUtil.ACTIVITY_CONFIG.getString("matePvpAcceptPrepareMsg");
            replaceMap.put("button", matePvpAcceptPrepareMsg);
            return replaceMap;
        }
        Integer time = MatchConstants.GUILD_PVP_MATCHING_TIME_MAP.get(guildInfoId);
        if (time != null && StrUtil.isNotEmpty(mateButton)) {
            button = mateButton.replace("${time}", String.valueOf(time));
        } else {
            int startDate = ConfigUtil.ACTIVITY_CONFIG.getInt("seasonPvp.startDate");
            Integer todayWeek = DateUtil.dayOfWeekEnum(new Date());
            if (todayWeek == startDate) {
                button = ConfigUtil.ACTIVITY_CONFIG.getString("stopButton");
            }
        }
        replaceMap.put("button", button);
        return replaceMap;
    }

    public void matePvpButtonTask(final HandyInventory handyInventory) {
        final Inventory inventory = handyInventory.getInventory();
        final Integer id = handyInventory.getId();
        final Player player = handyInventory.getPlayer();
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                Integer time = MatchConstants.GUILD_PVP_MATCHING_TIME_MAP.get(handyInventory.getId());
                if (time == null) {
                    this.cancel();
                }
                if (MatchConstants.GUILD_PVP_PREPARATION_MAP.get(id) != null) {
                    this.cancel();
                    HandySchedulerUtil.runTask(() -> ((Player)player).closeInventory());
                    return;
                }
                HandyInventoryUtil.setButton(ConfigUtil.ACTIVITY_CONFIG, inventory, "matePvp", GuildActivityGui.this.matePvpReplaceMap(handyInventory.getId()));
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(handyRunnable, 1L, 20L);
    }
}

