/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildNotice;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildNoticeReadService;
import com.handy.guild.service.GuildNoticeService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GuildNoticeGui {
    private static final GuildNoticeGui INSTANCE = new GuildNoticeGui();

    private GuildNoticeGui() {
    }

    public static GuildNoticeGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id, String type) {
        String title = ConfigUtil.NOTICE_CONFIG.getString("title");
        if ("noRead".equals(type)) {
            title = ConfigUtil.NOTICE_CONFIG.getString("noReadTitle");
        }
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.NOTICE_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_NOTICE.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setSearchType(type);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_NOTICE.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Integer guildId = handyInventory.getId();
        String searchType = handyInventory.getSearchType();
        handyInventory.setPageSize(GuildConstants.GUI_INDEX.size());
        List<Integer> readNoticeIds = GuildNoticeReadService.getInstance().findGuildNoticeId(guildId, player.getName());
        Page<GuildNotice> page = GuildNoticeService.getInstance().page(guildId, handyInventory.getPageNum(), handyInventory.getPageSize(), readNoticeIds, searchType);
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        List<GuildNotice> records = page.getRecords();
        List<Integer> guildNoticeIds = records.stream().map(GuildNotice::getId).collect(Collectors.toList());
        Map<Integer, Integer> guildNoticeReadMap = GuildNoticeReadService.getInstance().findMapByGuildNoticeIds(guildNoticeIds);
        String name = ConfigUtil.NOTICE_CONFIG.getString("notice.name", "");
        String materialStr = ConfigUtil.NOTICE_CONFIG.getString("notice.material");
        List loreList = ConfigUtil.NOTICE_CONFIG.getStringList("notice.lore");
        int customModelDataId = ConfigUtil.NOTICE_CONFIG.getInt("notice.custom-model-data");
        boolean hideFlag = ConfigUtil.NOTICE_CONFIG.getBoolean("notice.hideFlag", true);
        LinkedHashMap<Integer, ItemStack> itemStackMap = new LinkedHashMap<Integer, ItemStack>();
        for (GuildNotice guildNotice : records) {
            String newName = name.replace("${title}", BaseUtil.replaceChatColor(guildNotice.getTitle()));
            List<String> newLoreList = ItemStackUtil.loreBatchReplaceMap(loreList, GuildUtil.getDescriptionMap(guildNotice.getContent()), null);
            ItemStack itemStack = ItemStackUtil.getItemStack(materialStr, newName, newLoreList, !readNoticeIds.contains(guildNotice.getId()), customModelDataId, hideFlag, this.replaceMap(player, guildNotice, readNoticeIds, guildNoticeReadMap));
            itemStackMap.put(guildNotice.getId(), itemStack);
        }
        int i = 0;
        List<Integer> guiIndexList = GuildConstants.GUI_INDEX;
        for (Integer noticeId : itemStackMap.keySet()) {
            Integer index = guiIndexList.get(i++);
            inventory.setItem(index.intValue(), (ItemStack)itemStackMap.get(noticeId));
            map.put(index, noticeId);
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(handyInventory.getId());
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(handyInventory.getPlayer().getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.NOTICE_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.NOTICE_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.NOTICE_CONFIG, inventory, "back");
        if (guildPlayer.getRoleId() < GuildRoleEnum.THREE.getRoleId()) {
            HandyInventoryUtil.setButton(ConfigUtil.NOTICE_CONFIG, inventory, "send", this.sendNotice(guildInfo));
        }
        HandyInventoryUtil.setButton(ConfigUtil.NOTICE_CONFIG, inventory, "pane");
        HandyInventoryUtil.setButton(ConfigUtil.NOTICE_CONFIG, inventory, "search", this.getSearchMap(handyInventory));
    }

    private Map<String, String> getSearchMap(HandyInventory handyInventory) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(2);
        String searchType = handyInventory.getSearchType();
        String noRead = ConfigUtil.NOTICE_CONFIG.getString("search.noRead");
        String all = ConfigUtil.NOTICE_CONFIG.getString("search.all");
        if ("all".equals(searchType)) {
            replaceMap.put("type", all);
            replaceMap.put("nextType", noRead);
        }
        if ("noRead".equals(searchType)) {
            replaceMap.put("type", noRead);
            replaceMap.put("nextType", all);
        }
        return replaceMap;
    }

    private Map<String, String> sendNotice(GuildInfo guildInfo) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(3);
        Integer money = guildInfo.getMoney();
        String button = ConfigUtil.NOTICE_CONFIG.getString("send.noButton");
        int price = ConfigUtil.NOTICE_CONFIG.getInt("send.price");
        if (money >= price) {
            button = ConfigUtil.NOTICE_CONFIG.getString("send.yesButton");
        }
        replaceMap.put("button", button);
        replaceMap.put("guildMoney", money.toString());
        replaceMap.put("price", String.valueOf(price));
        return replaceMap;
    }

    private Map<String, String> replaceMap(Player player, GuildNotice guildNotice, List<Integer> readNoticeIds, Map<Integer, Integer> guildNoticeReadMap) {
        Optional<GuildPlayer> guildPlayerOptional1;
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(guildNotice.getSendPlayerName());
        if (!guildPlayerOptional.isPresent()) {
            return MapUtil.of();
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(5);
        replaceMap.put("player_name", BaseUtil.replaceChatColor(guildNotice.getSendPlayerName()));
        replaceMap.put("player_role", GuildRoleEnum.getRoleName(guildPlayer.getRoleId()));
        replaceMap.put("create_time", DateUtil.format(guildNotice.getCreateTime(), "yyyy-MM-dd HH:mm:ss"));
        String button = ConfigUtil.NOTICE_CONFIG.getString("noRead", "");
        if (readNoticeIds.contains(guildNotice.getId())) {
            button = ConfigUtil.NOTICE_CONFIG.getString("read", "");
        }
        if ((guildPlayerOptional1 = GuildPlayerService.getInstance().findByPlayerName(player.getName())).isPresent() && guildPlayerOptional1.get().getRoleId() < GuildRoleEnum.TWO.getRoleId()) {
            button = ConfigUtil.NOTICE_CONFIG.getString("del", "");
        }
        replaceMap.put("button", button);
        Integer size = guildNoticeReadMap.get(guildNotice.getId());
        replaceMap.put("read_number", size == null ? "0" : size.toString());
        return replaceMap;
    }
}

