/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener;

import com.handy.guild.PlayerGuild;
import com.handy.guild.command.player.CreateCommand;
import com.handy.guild.command.player.EditDescriptionCommand;
import com.handy.guild.command.player.EditGuildNameCommand;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.ShopBuyLimitTypeEnum;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildShop;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.NumberUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildShopService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.NoticeUtil;
import java.util.List;
import java.util.Optional;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

@HandyListener
public class AsyncPlayerChatEventListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onAsyncPlayerChatEvent(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String type = GuildConstants.CREATE_GUILD_INFO_MAP.get(player.getUniqueId());
        if (StrUtil.isEmpty(type)) {
            return;
        }
        event.setCancelled(true);
        String msg = event.getMessage();
        String stripColorMsg = BaseUtil.stripColor(msg);
        if ("T".equalsIgnoreCase(stripColorMsg)) {
            MessageUtil.sendMessage(player, ConfigUtil.OPEN_CONFIG.getString("create.cancelMsh"));
            GuildConstants.CREATE_GUILD_INFO_MAP.remove(player.getUniqueId());
            return;
        }
        if ("sell".equals(type)) {
            this.sell(player, stripColorMsg);
            return;
        }
        if ("add".equals(type)) {
            CreateCommand.create(player, msg);
        }
        if ("edit".equals(type)) {
            EditGuildNameCommand.editGuildName(player, msg);
        }
        if ("editDescription".equals(type)) {
            EditDescriptionCommand.editDescription(player, msg);
        }
        if ("custom".equals(type)) {
            this.custom(player, stripColorMsg);
        }
        if ("send".equals(type)) {
            NoticeUtil.sendNotice(player, msg);
        }
        GuildConstants.CREATE_GUILD_INFO_MAP.remove(player.getUniqueId());
    }

    private void custom(Player player, String msg) {
        Integer price = NumberUtil.isNumericToInt(msg);
        if (price == null || price <= 0) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("amountFailureMsg"));
            return;
        }
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        Integer money = guildPlayer.getMoney();
        if (money < price) {
            MessageUtil.sendMessage(player, ConfigUtil.BANK_CONFIG.getString("noButton"));
            return;
        }
        GuildPlayerService.getInstance().subtractMoneyById(guildPlayer.getId(), price);
        GuildPlayerService.getInstance().addGuildMoneyById(guildPlayer.getId(), price);
        GuildInfoService.getInstance().addMoneyById(guildPlayer.getGuildInfoId(), price);
        MessageUtil.sendMessage(player, ConfigUtil.BANK_CONFIG.getString("succeedMsg"));
    }

    private void sell(Player player, String msg) {
        Boolean removeItemRst;
        String[] split = msg.split("#");
        if (split.length != 2) {
            MessageUtil.sendMessage(player, ConfigUtil.SHOP_CONFIG.getString("sellErrorOneMsg"));
            return;
        }
        Integer number = NumberUtil.isNumericToInt(split[0]);
        Integer price = NumberUtil.isNumericToInt(split[1]);
        if (number == null) {
            MessageUtil.sendMessage(player, ConfigUtil.SHOP_CONFIG.getString("sellErrorOneMsg"));
            return;
        }
        if (number < 1) {
            MessageUtil.sendMessage(player, ConfigUtil.SHOP_CONFIG.getString("sellErrorNumberMsg"));
            return;
        }
        if (price == null) {
            MessageUtil.sendMessage(player, ConfigUtil.SHOP_CONFIG.getString("sellErrorOneMsg"));
            return;
        }
        if (price < 1) {
            MessageUtil.sendMessage(player, ConfigUtil.SHOP_CONFIG.getString("sellErrorPriceMsg"));
            return;
        }
        PlayerInventory playerInventory = player.getInventory();
        ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(playerInventory);
        if (itemInMainHand == null || Material.AIR.equals((Object)itemInMainHand.getType())) {
            MessageUtil.sendMessage(player, ConfigUtil.SHOP_CONFIG.getString("sellErrorItemMsg"));
            return;
        }
        List loreBlackList = ConfigUtil.SHOP_CONFIG.getStringList("loreBlackList");
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemInMainHand);
        if (CollUtil.isNotEmpty(itemMeta.getLore()) && CollUtil.isNotEmpty(loreBlackList)) {
            for (String lore : loreBlackList) {
                for (String loreStr : itemMeta.getLore()) {
                    if (!loreStr.contains(lore)) continue;
                    MessageUtil.sendMessage(player, ConfigUtil.SHOP_CONFIG.getString("sellLoreErrorNumberMsg"));
                    return;
                }
            }
        }
        if (!(removeItemRst = ItemStackUtil.removeItem(playerInventory, itemInMainHand, number)).booleanValue()) {
            MessageUtil.sendMessage(player, ConfigUtil.SHOP_CONFIG.getString("sellErrorNumberMsg"));
            return;
        }
        GuildShop guildShop = new GuildShop();
        guildShop.setPrice(price);
        guildShop.setLevel(1);
        guildShop.setNumber(number);
        ItemStack clone = itemInMainHand.clone();
        clone.setAmount(1);
        guildShop.setItemStack(ItemStackUtil.itemStackSerialize(clone));
        guildShop.setPlayerName(player.getName());
        guildShop.setPlayerUuid(player.getUniqueId().toString());
        guildShop.setGuildInfoId(GuildConstants.PLAYER_GUILD_MAP.get(player.getUniqueId()).getGuildInfoId());
        guildShop.setType(ShopBuyLimitTypeEnum.ONLY.getName());
        GuildShopService.getInstance().add(guildShop);
        MessageUtil.sendMessage(player, ConfigUtil.SHOP_CONFIG.getString("sellYesMsg"));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEssChat(AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (PlayerGuild.USE_PAPI && ConfigUtil.CONFIG.getBoolean("essChat", false)) {
            event.setFormat(BaseUtil.replaceChatColor(PlaceholderAPI.setBracketPlaceholders((Player)event.getPlayer(), (String)event.getFormat())));
        }
    }
}

