/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener;

import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildPlayerCooling;
import com.handy.guild.event.PlayerLeaveGuildEvent;
import com.handy.guild.hook.PlayerChatUtil;
import com.handy.guild.hook.PlayerTitleUtil;
import com.handy.guild.hook.WorldUtil;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerCoolingService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildShopService;
import com.handy.guild.util.BuffManageUtil;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@HandyListener
public class PlayerLeaveGuildEventListener
implements Listener {
    @EventHandler
    public void onPlayerLeaveGuild(PlayerLeaveGuildEvent event) {
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findById(event.getGuildPlayerId());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId());
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        GuildInfoService.getInstance().subtractMemberCount(guildPlayer.getGuildInfoId(), 1);
        GuildPlayerService.getInstance().deleteById(guildPlayer.getId());
        PlayerTitleUtil.removeGuildPlayerTitle(guildPlayer.getPlayerName(), guildInfo.getTitleId());
        WorldUtil.removePlayerFromWorld(guildPlayer.getPlayerName(), guildInfo.getWorldName());
        GuildShopService.getInstance().delByPlayerName(guildPlayer.getPlayerName());
        if ("activeLeave".equals(event.getLeaveType())) {
            Player player2 = event.getPlayer();
            GuildPlayerCooling guildPlayerCooling = new GuildPlayerCooling();
            guildPlayerCooling.setPlayerName(player2.getName());
            guildPlayerCooling.setPlayerUuid(player2.getUniqueId().toString());
            guildPlayerCooling.setLeaveTime(new Date());
            GuildPlayerCoolingService.getInstance().add(guildPlayerCooling);
        }
        GuildConstants.PLAYER_GUILD_MAP.remove(UUID.fromString(guildPlayer.getPlayerUuid()));
        Optional<Player> onlinePlayerOpt = BaseUtil.getOnlinePlayer(guildPlayer.getPlayerName());
        onlinePlayerOpt.ifPresent(player -> BuffManageUtil.removeBuff(player));
        MessageUtil.sendMessage(guildPlayer.getPlayerName(), BaseUtil.getLangMsg("leaveMsg").replace("${guild_name}", guildPlayer.getGuildInfoName()));
        Player player3 = event.getPlayer() != null ? event.getPlayer() : (Player)BaseUtil.getOnlinePlayer(event.getOfflinePlayer().getUniqueId()).orElse(null);
        PlayerChatUtil.unRegPlayerChannel(player3, guildInfo.getId());
        PlayerChatUtil.setPlayerChannelToDefault(player3);
    }
}

