/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener;

import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildTaskDemand;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildTaskDemandService;
import com.handy.guild.service.GuildTaskService;
import com.handy.playertask.event.PlayerTaskScheduleEvent;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@HandyListener
public class PlayerTaskScheduleEventListener
implements Listener {
    @EventHandler
    public void onPlayerTaskSchedule(PlayerTaskScheduleEvent event) {
        Player player = event.getPlayer();
        Integer amount = event.getAmount();
        String content = event.getContent();
        String demandType = event.getDemandType();
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            long l = System.currentTimeMillis();
            Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
            if (!guildPlayerOptional.isPresent()) {
                return;
            }
            GuildPlayer guildPlayer = guildPlayerOptional.get();
            List<GuildTaskDemand> guildTaskDemandList = GuildTaskDemandService.getInstance().findByGuildIdAndContent(guildPlayer.getGuildInfoId(), content, demandType);
            if (CollUtil.isEmpty(guildTaskDemandList)) {
                return;
            }
            for (GuildTaskDemand taskNpcPlayerDemand : guildTaskDemandList) {
                GuildTaskDemandService.getInstance().updateCompletionAmount(taskNpcPlayerDemand.getId(), amount);
                Boolean rst = GuildTaskDemandService.getInstance().findCountByGuildTaskId(taskNpcPlayerDemand.getGuildTaskId());
                if (rst.booleanValue()) continue;
                GuildTaskService.getInstance().updateDemandSuccess(taskNpcPlayerDemand.getGuildTaskId(), true);
            }
            MessageUtil.sendConsoleDebugMessage("&a\u516c\u4f1a\u4efb\u52a1\u6267\u884c \u6beb\u79d2:" + (System.currentTimeMillis() - l));
        });
    }
}

