/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.match;

import com.handy.guild.constants.GuildActivityType;
import com.handy.guild.constants.MatchConstants;
import com.handy.guild.enter.GuildEquipment;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPvpLocation;
import com.handy.guild.enter.GuildSpawnPvpLocation;
import com.handy.guild.event.GuildPvpStartEvent;
import com.handy.guild.lib.annotation.HandyListener;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.expand.adapter.HandyRunnable;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.expand.adapter.PlayerSchedulerUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.param.GuildPvpPlayerParam;
import com.handy.guild.service.GuildEquipmentService;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPvpLocationService;
import com.handy.guild.service.GuildSpawnPvpLocationService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import com.handy.guild.util.KitPvpUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

@HandyListener
public class GuildPvpStartEventListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onGuildPvpStart(GuildPvpStartEvent event) {
        Chunk chunkAt;
        Player guildOnlinePlayer;
        GuildPvpLocation guildPvpLocation;
        List<Integer> guildIdList = event.getGuildIdList();
        Integer oneGuildId = guildIdList.get(0);
        Integer twoGuildId = guildIdList.get(1);
        ArrayList allList = new ArrayList();
        for (Integer guildId : guildIdList) {
            allList.addAll(MatchConstants.GUILD_PVP_PREPARATION_MAP.get(guildId));
        }
        ArrayList<Integer> locationIdList = new ArrayList<Integer>();
        for (UUID uuid : allList) {
            Integer id = MatchConstants.GUILD_PVP_PREPARATION_LOCATION_MAP.get(uuid);
            if (id == null) continue;
            locationIdList.add(id);
        }
        if (CollUtil.isNotEmpty(locationIdList)) {
            Collections.shuffle(locationIdList);
            guildPvpLocation = GuildPvpLocationService.getInstance().findById((Integer)locationIdList.get(0)).orElse(null);
        } else {
            List exitIds = new ArrayList<Integer>();
            if (!MatchConstants.GUILD_PVP_START_LOCATION_MAP.isEmpty()) {
                ArrayList<Integer> guildLocationId = new ArrayList<Integer>();
                for (Integer guildId : MatchConstants.GUILD_PVP_START_LOCATION_MAP.keySet()) {
                    guildLocationId.add(MatchConstants.GUILD_PVP_START_LOCATION_MAP.get(guildId));
                }
                exitIds = guildLocationId.stream().distinct().collect(Collectors.toList());
            }
            List<GuildPvpLocation> guildPvpLocations = GuildPvpLocationService.getInstance().listByNotIds(GuildActivityType.MATCH.getType(), exitIds);
            Collections.shuffle(guildPvpLocations);
            guildPvpLocation = guildPvpLocations.get(0);
        }
        for (Integer guildId : guildIdList) {
            MatchConstants.GUILD_PVP_START_LOCATION_MAP.put(guildId, guildPvpLocation.getId());
        }
        MatchConstants.GUILD_PVP_PREPARATION_LOCATION_MAP.clear();
        List<GuildSpawnPvpLocation> spawnList = GuildSpawnPvpLocationService.getInstance().list(guildPvpLocation.getId());
        GuildSpawnPvpLocation firstLocation = spawnList.get(0);
        GuildSpawnPvpLocation secondLocation = spawnList.get(0);
        Location lookLocation = null;
        if (spawnList.size() > 1) {
            secondLocation = spawnList.get(1);
        }
        if (spawnList.size() == 3) {
            lookLocation = GuildUtil.getLocation(spawnList.get(2));
        }
        Date startTime = new Date();
        for (Integer guildId : guildIdList) {
            List<UUID> uuidList = MatchConstants.GUILD_PVP_PREPARATION_MAP.get(guildId);
            ArrayList<GuildPvpPlayerParam> pvpPlayerParamList = new ArrayList<GuildPvpPlayerParam>();
            Iterator<UUID> iterator = uuidList.iterator();
            while (iterator.hasNext()) {
                UUID uuid = iterator.next();
                Optional<Player> onlinePlayerOpt = BaseUtil.getOnlinePlayer(uuid);
                if (!onlinePlayerOpt.isPresent() || (guildOnlinePlayer = onlinePlayerOpt.get()).isDead()) continue;
                GuildPvpPlayerParam param = new GuildPvpPlayerParam();
                param.setMeGuildId(guildId);
                param.setRivalGuildId(guildId.equals(oneGuildId) ? twoGuildId : oneGuildId);
                param.setPlayerName(guildOnlinePlayer.getName());
                param.setPlayerUuid(uuid);
                param.setKill(0);
                param.setIsDeath(false);
                pvpPlayerParamList.add(param);
                MatchConstants.GUILD_PVP_START_PLAYER_LOCATION_MAP.put(uuid, guildOnlinePlayer.getLocation());
            }
            MatchConstants.GUILD_PVP_START_PLAYER_MAP.put(guildId, pvpPlayerParamList);
            MatchConstants.GUILD_PVP_PREPARATION_MAP.remove(guildId);
            if (lookLocation != null) {
                MatchConstants.LOOK_LOCATION.put(guildId, lookLocation);
            }
            MatchConstants.START_TIME.put(guildId, startTime);
        }
        List<GuildPvpPlayerParam> onePvpPlayerParamList = MatchConstants.GUILD_PVP_START_PLAYER_MAP.get(oneGuildId);
        List<GuildPvpPlayerParam> twoPvpPlayerParamList = MatchConstants.GUILD_PVP_START_PLAYER_MAP.get(twoGuildId);
        if (CollUtil.isEmpty(onePvpPlayerParamList) || CollUtil.isEmpty(twoPvpPlayerParamList)) {
            for (Integer guildId : guildIdList) {
                List<GuildPvpPlayerParam> pvpPlayerParamList = MatchConstants.GUILD_PVP_START_PLAYER_MAP.get(guildId);
                for (GuildPvpPlayerParam param : pvpPlayerParamList) {
                    MatchConstants.GUILD_PVP_START_PLAYER_LOCATION_MAP.remove(param.getPlayerUuid());
                    MessageUtil.sendMessage(param.getPlayerUuid(), ConfigUtil.ACTIVITY_CONFIG.getString("noPlayer"));
                }
                MatchConstants.GUILD_PVP_START_PLAYER_MAP.remove(guildId);
                MatchConstants.GUILD_PVP_START_LOCATION_MAP.remove(guildId);
                MatchConstants.LOOK_LOCATION.remove(guildId);
                MatchConstants.START_TIME.remove(guildId);
            }
            return;
        }
        Location oneLocation = GuildUtil.getLocation(firstLocation);
        Location twoLocation = GuildUtil.getLocation(secondLocation);
        if (oneLocation.getWorld() != null && !(chunkAt = oneLocation.getWorld().getChunkAt(oneLocation)).isLoaded()) {
            chunkAt.load();
        }
        if (twoLocation.getWorld() != null && !(chunkAt = twoLocation.getWorld().getChunkAt(twoLocation)).isLoaded()) {
            chunkAt.load();
        }
        List<GuildEquipment> guildEquipments = GuildEquipmentService.getInstance().findAll();
        for (GuildPvpPlayerParam param : onePvpPlayerParamList) {
            guildOnlinePlayer = Bukkit.getPlayer((UUID)param.getPlayerUuid());
            if (guildOnlinePlayer == null || !guildOnlinePlayer.isOnline() || guildOnlinePlayer.getHealth() <= 0.0) continue;
            PlayerSchedulerUtil.teleport((Entity)guildOnlinePlayer, oneLocation);
            KitPvpUtil.kitPvp(guildOnlinePlayer);
            KitPvpUtil.equipment(guildOnlinePlayer, Color.BLUE, guildEquipments);
            MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.put(param.getPlayerUuid(), param.getMeGuildId());
        }
        for (GuildPvpPlayerParam param : twoPvpPlayerParamList) {
            Player guildOnlinePlayer2;
            Optional<Player> onlinePlayerOpt = BaseUtil.getOnlinePlayer(param.getPlayerUuid());
            if (!onlinePlayerOpt.isPresent() || (guildOnlinePlayer2 = onlinePlayerOpt.get()).isDead()) continue;
            PlayerSchedulerUtil.teleport((Entity)guildOnlinePlayer2, twoLocation);
            KitPvpUtil.kitPvp(guildOnlinePlayer2);
            KitPvpUtil.equipment(guildOnlinePlayer2, Color.RED, guildEquipments);
            MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.put(param.getPlayerUuid(), param.getMeGuildId());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onGuildPvpStartToOp(GuildPvpStartEvent event) {
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            List<Integer> guildIdList = event.getGuildIdList();
            for (Integer guildId : guildIdList) {
                List<GuildPvpPlayerParam> pvpPlayerParamList = MatchConstants.GUILD_PVP_START_PLAYER_MAP.get(guildId);
                if (!CollUtil.isEmpty(pvpPlayerParamList)) continue;
                return;
            }
            String range = ConfigUtil.ACTIVITY_CONFIG.getString("notice.range", "not");
            if ("not".equalsIgnoreCase(range)) {
                return;
            }
            String msg = ConfigUtil.ACTIVITY_CONFIG.getString("notice.msg", "");
            List<GuildInfo> guildInfoList = GuildInfoService.getInstance().findByIds(event.getGuildIdList());
            GuildInfo one = guildInfoList.get(0);
            GuildInfo two = guildInfoList.get(1);
            msg = msg.replace("${one}", one.getGuildName()).replace("${two}", two.getGuildName());
            if ("op".equalsIgnoreCase(range)) {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    if (!onlinePlayer.isOp()) continue;
                    MessageUtil.sendMessage(onlinePlayer, msg);
                }
            } else if ("all".equalsIgnoreCase(range)) {
                MessageUtil.sendAllMessage(msg);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void strikeLightning(GuildPvpStartEvent event) {
        final List<Integer> guildIdList = event.getGuildIdList();
        final int matePvpTime = ConfigUtil.ACTIVITY_CONFIG.getInt("matePvpTime", 300);
        if (matePvpTime < 1) {
            return;
        }
        final String matePvpTimeMsg = BaseUtil.replaceChatColor(ConfigUtil.ACTIVITY_CONFIG.getString("matePvpTimeMsg", ""));
        final int[] number = new int[]{0};
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                number[0] = number[0] + 1;
                for (Integer guildId : guildIdList) {
                    List<GuildPvpPlayerParam> pvpPlayerParamList = MatchConstants.GUILD_PVP_START_PLAYER_MAP.get(guildId);
                    if (CollUtil.isEmpty(pvpPlayerParamList)) {
                        this.cancel();
                        return;
                    }
                    if (number[0] < matePvpTime) continue;
                    for (GuildPvpPlayerParam guildPvpPlayerParam : pvpPlayerParamList) {
                        Player guildOnlinePlayer;
                        if (guildPvpPlayerParam.getIsDeath().booleanValue() || (guildOnlinePlayer = Bukkit.getPlayer((String)guildPvpPlayerParam.getPlayerName())) == null || !guildOnlinePlayer.isOnline() || guildOnlinePlayer.getHealth() <= 0.0) continue;
                        double damage = guildOnlinePlayer.getMaxHealth() * 0.1;
                        int health = (int)(guildOnlinePlayer.getHealth() - (damage < 2.0 ? 2.0 : damage));
                        if (health <= 0) {
                            HandySchedulerUtil.runTask(() -> guildOnlinePlayer.setHealth(0.0));
                            continue;
                        }
                        guildOnlinePlayer.setHealth((double)health);
                        MessageUtil.sendActionbar(guildOnlinePlayer, matePvpTimeMsg);
                    }
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(handyRunnable, 1L, 20L);
    }
}

