/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.constants.GuildSortEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.db.Compare;
import com.handy.guild.lib.db.Db;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.service.GuildApplyService;
import com.handy.guild.service.GuildBuffService;
import com.handy.guild.service.GuildLogoService;
import com.handy.guild.service.GuildNoticeReadService;
import com.handy.guild.service.GuildNoticeService;
import com.handy.guild.service.GuildPlayerPickaxeService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildPlayerSignInService;
import com.handy.guild.service.GuildTaskDemandService;
import com.handy.guild.service.GuildTaskService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class GuildInfoService {
    private GuildInfoService() {
    }

    public static GuildInfoService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void addMemberCount(Integer guildId, Integer count) {
        Db<GuildInfo> guildInfoUpdateDb = Db.use(GuildInfo.class);
        guildInfoUpdateDb.update().add(GuildInfo::getMemberCount, GuildInfo::getMemberCount, count);
        guildInfoUpdateDb.execution().updateById(guildId);
    }

    public void subtractMemberCount(Integer guildId, Integer count) {
        Db<GuildInfo> guildInfoUpdateDb = Db.use(GuildInfo.class);
        guildInfoUpdateDb.update().subtract(GuildInfo::getMemberCount, GuildInfo::getMemberCount, count);
        guildInfoUpdateDb.execution().updateById(guildId);
    }

    public int updateSpawnLocation(Integer guildId, String spawnLocation, String worldName) {
        Db<GuildInfo> guildInfoUpdateDb = Db.use(GuildInfo.class);
        guildInfoUpdateDb.update().set(StrUtil.isNotEmpty(worldName), GuildInfo::getWorldName, worldName).set(StrUtil.isNotEmpty(spawnLocation), GuildInfo::getSpawnLocation, spawnLocation);
        return guildInfoUpdateDb.execution().updateById(guildId);
    }

    public void upLevel(Integer guildId, Integer level, Integer memberMaxCount) {
        Db<GuildInfo> guildInfoUpdateDb = Db.use(GuildInfo.class);
        guildInfoUpdateDb.update().add(level != null, GuildInfo::getLevel, GuildInfo::getLevel, level).set(memberMaxCount != null, GuildInfo::getMemberMaxCount, memberMaxCount);
        guildInfoUpdateDb.execution().updateById(guildId);
    }

    public int add(GuildInfo guildInfo) {
        return Db.use(GuildInfo.class).execution().insert(guildInfo);
    }

    public Optional<GuildInfo> findByGuildName(String guildName) {
        Db<GuildInfo> guildInfoDb = Db.use(GuildInfo.class);
        guildInfoDb.where().eq(GuildInfo::getGuildName, guildName);
        return guildInfoDb.execution().selectOne();
    }

    public Optional<GuildInfo> findById(Integer id) {
        return Db.use(GuildInfo.class).execution().selectById(id);
    }

    public List<GuildInfo> findAll() {
        return Db.use(GuildInfo.class).execution().list();
    }

    public List<String> findNameAll() {
        return this.findAll().stream().map(GuildInfo::getGuildName).collect(Collectors.toList());
    }

    public List<GuildInfo> findByIds(List<Integer> ids) {
        return Db.use(GuildInfo.class).execution().selectBatchIds(ids);
    }

    public Page<GuildInfo> page(Integer pageNum, Integer pageSize, String sortName) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        Compare<GuildInfo> where = db.where();
        where.limit(pageNum, pageSize);
        GuildSortEnum guildSortEnum = GuildSortEnum.getEnum(sortName);
        switch (guildSortEnum) {
            case LEVEL: {
                where.orderByDesc(GuildInfo::getLevel);
                break;
            }
            case MONEY: {
                where.orderByDesc(GuildInfo::getMoney);
                break;
            }
            case CREATE_TIME: {
                where.orderByDesc(GuildInfo::getCreateTime);
                break;
            }
            case MEMBER_COUNT: {
                where.orderByDesc(GuildInfo::getMemberCount);
                break;
            }
            default: {
                where.orderByDesc(GuildInfo::getProsperityDegree);
                break;
            }
            case MONTH_PROSPERITY_DEGREE: {
                where.orderByDesc(GuildInfo::getMonthProsperityDegree);
            }
        }
        return db.execution().page();
    }

    public Optional<GuildInfo> findByWorldName(String worldName) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.where().eq(GuildInfo::getWorldName, worldName).limit(1, 1);
        return db.execution().selectOne();
    }

    public List<GuildInfo> list() {
        return Db.use(GuildInfo.class).execution().list();
    }

    public void addProsperityDegreeById(Integer id, Integer prosperityDegree) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().add(GuildInfo::getProsperityDegree, GuildInfo::getProsperityDegree, prosperityDegree).add(GuildInfo::getMonthProsperityDegree, GuildInfo::getMonthProsperityDegree, prosperityDegree);
        db.execution().updateById(id);
    }

    public void addOreById(Integer id, Integer ore) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().add(GuildInfo::getOre, GuildInfo::getOre, ore);
        db.execution().updateById(id);
    }

    public boolean addOreByName(String name, Integer ore) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().add(GuildInfo::getOre, GuildInfo::getOre, ore);
        db.where().eq(GuildInfo::getGuildName, name);
        return db.execution().update() > 0;
    }

    public boolean subtractOreByName(String name, Integer ore) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().subtract(GuildInfo::getOre, GuildInfo::getOre, ore);
        db.where().eq(GuildInfo::getGuildName, name);
        return db.execution().update() > 0;
    }

    public boolean setOreByName(String name, Integer ore) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().set(GuildInfo::getOre, ore);
        db.where().eq(GuildInfo::getGuildName, name);
        return db.execution().update() > 0;
    }

    public boolean addProsperityDegreeByName(String name, Integer prosperityDegree) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().add(GuildInfo::getProsperityDegree, GuildInfo::getProsperityDegree, prosperityDegree).add(GuildInfo::getMonthProsperityDegree, GuildInfo::getMonthProsperityDegree, prosperityDegree);
        db.where().eq(GuildInfo::getGuildName, name);
        return db.execution().update() > 0;
    }

    public void subtractProsperityDegreeById(Integer id, Integer prosperityDegree) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().subtract(GuildInfo::getProsperityDegree, GuildInfo::getProsperityDegree, prosperityDegree);
        db.execution().updateById(id);
    }

    public boolean subtractProsperityDegreeByName(String name, Integer prosperityDegree) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().subtract(GuildInfo::getProsperityDegree, GuildInfo::getProsperityDegree, prosperityDegree);
        db.where().eq(GuildInfo::getGuildName, name);
        return db.execution().update() > 0;
    }

    public void setProsperityDegreeById(Integer id, Integer prosperityDegree) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().set(GuildInfo::getProsperityDegree, prosperityDegree);
        db.execution().updateById(id);
    }

    public boolean setProsperityDegreeByName(String name, Integer prosperityDegree) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().set(GuildInfo::getProsperityDegree, prosperityDegree);
        db.where().eq(GuildInfo::getGuildName, name);
        return db.execution().update() > 0;
    }

    public void addSacredStoneLevelById(Integer id, Integer sacredStoneLevel) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().add(GuildInfo::getSacredStoneLevel, GuildInfo::getSacredStoneLevel, sacredStoneLevel);
        db.execution().updateById(id);
    }

    public void addMoneyById(Integer id, Integer money) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().add(GuildInfo::getMoney, GuildInfo::getMoney, money);
        db.execution().updateById(id);
    }

    public boolean addMoneyByName(String name, Integer money) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().add(GuildInfo::getMoney, GuildInfo::getMoney, money);
        db.where().eq(GuildInfo::getGuildName, name);
        return db.execution().update() > 0;
    }

    public void subtractMoneyById(Integer id, Integer money) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().subtract(GuildInfo::getMoney, GuildInfo::getMoney, money);
        db.execution().updateById(id);
    }

    public void subtractOreById(Integer id, Integer ore) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().subtract(GuildInfo::getOre, GuildInfo::getOre, ore);
        db.execution().updateById(id);
    }

    public boolean subtractMoneyByName(String name, Integer money) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().subtract(GuildInfo::getMoney, GuildInfo::getMoney, money);
        db.where().eq(GuildInfo::getGuildName, name);
        return db.execution().update() > 0;
    }

    public void setMoneyById(Integer id, Integer money) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().set(GuildInfo::getMoney, money);
        db.execution().updateById(id);
    }

    public boolean setMoneyByName(String name, Integer money) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().set(GuildInfo::getMoney, money);
        db.where().eq(GuildInfo::getGuildName, name);
        return db.execution().update() > 0;
    }

    public void updateLogoById(Integer guildId, Integer logoId, String logoName) {
        Db<GuildInfo> use = Db.use(GuildInfo.class);
        use.update().set(GuildInfo::getLogoId, logoId).set(GuildInfo::getLogoName, logoName);
        use.execution().updateById(guildId);
    }

    public void updateTitleIdById(Integer guildId, Long titleId) {
        Db<GuildInfo> use = Db.use(GuildInfo.class);
        use.update().set(GuildInfo::getTitleId, titleId);
        use.execution().updateById(guildId);
    }

    public void editGuildName(Integer guildId, String guildName, Integer price) {
        Db<GuildInfo> use = Db.use(GuildInfo.class);
        use.update().set(GuildInfo::getGuildName, guildName).subtract(GuildInfo::getMoney, GuildInfo::getMoney, price);
        use.execution().updateById(guildId);
        GuildPlayerService.getInstance().editPlayerGuildName(guildId, guildName);
    }

    public void editguildDescription(Integer guildId, String guildDescription, Integer price) {
        Db<GuildInfo> use = Db.use(GuildInfo.class);
        use.update().set(GuildInfo::getDescription, guildDescription).subtract(GuildInfo::getMoney, GuildInfo::getMoney, price);
        use.execution().updateById(guildId);
    }

    public void editPlayerPvpStatus(Integer guildId, boolean pvpStatus, Integer price) {
        Db<GuildInfo> use = Db.use(GuildInfo.class);
        use.update().set(GuildInfo::getPvpStatus, pvpStatus).subtract(GuildInfo::getMoney, GuildInfo::getMoney, price);
        use.execution().updateById(guildId);
        GuildPlayerService.getInstance().editPlayerPvpStatus(guildId, pvpStatus);
    }

    public void editJoinMode(Integer guildId, boolean joinMode, Integer price) {
        Db<GuildInfo> use = Db.use(GuildInfo.class);
        use.update().set(GuildInfo::getJoinMode, joinMode).subtract(GuildInfo::getMoney, GuildInfo::getMoney, price);
        use.execution().updateById(guildId);
    }

    public void delByGuildId(Integer guildId) {
        Db.use(GuildInfo.class).execution().deleteById(guildId);
        GuildApplyService.getInstance().delByGuildId(guildId);
        GuildLogoService.getInstance().delByGuildId(guildId);
        GuildPlayerService.getInstance().delByGuildId(guildId);
        GuildPlayerSignInService.getInstance().delByGuildId(guildId);
        GuildTaskService.getInstance().delByGuildId(guildId);
        GuildTaskDemandService.getInstance().delByGuildId(guildId);
        GuildNoticeService.getInstance().delByGuildId(guildId);
        GuildNoticeReadService.getInstance().delByGuildId(guildId);
        GuildPlayerPickaxeService.getInstance().delByGuildId(guildId);
        GuildBuffService.getInstance().delByGuildId(guildId);
    }

    public void setMonthProsperityDegreeById(Integer id, Integer monthProsperityDegree) {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().set(GuildInfo::getMonthProsperityDegree, monthProsperityDegree);
        db.execution().updateById(id);
    }

    public void updateLogoByLogoId(Integer logoId, String logoName) {
        Db<GuildInfo> use = Db.use(GuildInfo.class);
        use.update().set(GuildInfo::getLogoName, logoName);
        use.where().eq(GuildInfo::getLogoId, logoId);
        use.execution().update();
    }

    public void updateOre() {
        Db<GuildInfo> db = Db.use(GuildInfo.class);
        db.update().set(GuildInfo::getOre, 0);
        db.where().isNull(GuildInfo::getOre);
        db.execution().update();
    }

    public Integer findCount() {
        return Db.use(GuildInfo.class).execution().count();
    }

    private static class SingletonHolder {
        private static final GuildInfoService INSTANCE = new GuildInfoService();

        private SingletonHolder() {
        }
    }
}

