/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.lib.util;

import com.google.common.collect.Maps;
import com.handy.playertask.lib.InitApi;
import com.handy.playertask.lib.constants.BaseConstants;
import com.handy.playertask.lib.core.HttpUtil;
import com.handy.playertask.lib.core.JsonUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.expand.adapter.HandyRunnable;
import com.handy.playertask.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.lib.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class HandyHttpUtil {
    private HandyHttpUtil() {
    }

    public static void checkVersion(Player player, String url) {
        if (player != null && !player.isOp()) {
            return;
        }
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            String version = InitApi.PLUGIN.getDescription().getVersion();
            Optional<String> tagNameOpt = BaseUtil.getOfficialVersion(url);
            if (tagNameOpt.isPresent() && BaseUtil.convertVersion(tagNameOpt.get()) > BaseUtil.convertVersion(version)) {
                String oneMsg = ChatColor.GRAY + "_________________/ &e" + InitApi.PLUGIN.getDescription().getName() + ChatColor.GRAY + " \\_________________\n";
                TextComponent message = TextUtil.getInstance().init(oneMsg).build();
                String twoMsg = "&7| &a\u6700\u65b0\u7248\u672c: &d" + tagNameOpt.get() + " &a\u5f53\u524d\u7248\u672c: &d" + version + " &a\u70b9\u51fb&d&n\u6b64\u5904\u67e5\u770b&a\u66f4\u65b0\u5185\u5bb9 &7|\n";
                message.addExtra((BaseComponent)TextUtil.getInstance().init("     " + twoMsg).addClickUrl(InitApi.PLUGIN.getDescription().getWebsite()).build());
                message.addExtra((BaseComponent)TextUtil.getInstance().init(ChatColor.GRAY + "-----------------------------------------------").build());
                if (player == null) {
                    MessageUtil.sendConsoleMessage(twoMsg);
                } else {
                    MessageUtil.sendMessage(player, message);
                }
            }
        });
    }

    public static void getZhCn() {
        switch (BaseConstants.VERSION_CHECK_ENUM) {
            case V_1_7: 
            case V_1_8: 
            case V_1_9: 
            case V_1_10: 
            case V_1_11: 
            case V_1_12: {
                break;
            }
            case V_1_13: {
                HandyHttpUtil.getCloudZhCn("https://oss.handyplus.cn/public/zh_cn/1.13.json");
                break;
            }
            case V_1_14: {
                HandyHttpUtil.getCloudZhCn("https://oss.handyplus.cn/public/zh_cn/1.14.json");
                break;
            }
            case V_1_15: {
                HandyHttpUtil.getCloudZhCn("https://oss.handyplus.cn/public/zh_cn/1.15.json");
                break;
            }
            case V_1_16: {
                HandyHttpUtil.getCloudZhCn("https://oss.handyplus.cn/public/zh_cn/1.16.json");
                break;
            }
            case V_1_17: {
                HandyHttpUtil.getCloudZhCn("https://oss.handyplus.cn/public/zh_cn/1.17.json");
                break;
            }
            case V_1_18: {
                HandyHttpUtil.getCloudZhCn("https://oss.handyplus.cn/public/zh_cn/1.18.json");
                break;
            }
            case V_1_19: {
                HandyHttpUtil.getCloudZhCn("https://oss.handyplus.cn/public/zh_cn/1.19.json");
                break;
            }
            default: {
                HandyHttpUtil.getCloudZhCn("https://oss.handyplus.cn/public/zh_cn/1.20.json");
            }
        }
    }

    private static void getCloudZhCn(final String url) {
        final AtomicInteger retryNumber = new AtomicInteger(6);
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        HttpUtil.downloadFile(url, InitApi.PLUGIN.getDataFolder(), "zh_cn.json");
                        File zhChFile = new File(InitApi.PLUGIN.getDataFolder(), "zh_cn.json");
                        if (zhChFile.exists()) {
                            BaseUtil.readJsonFileToJsonCacheMap(zhChFile);
                        }
                        this.cancel();
                    }
                    catch (Exception ignored) {
                        retryNumber.getAndDecrement();
                        if (retryNumber.get() >= 1) break block3;
                        this.cancel();
                    }
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(handyRunnable, 40L, 1200L);
    }

    public static void setCloudItemJsonCacheMap(final String version) {
        final AtomicInteger retryNumber = new AtomicInteger(6);
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)1);
                        paramMap.put("version", version);
                        String result = HttpUtil.get(BaseConstants.CLOUD_GET_URL, paramMap);
                        if (StrUtil.isNotEmpty(result)) {
                            BaseConstants.CLOUD_ITEM_JSON_CACHE_MAP = JsonUtil.toMap(result);
                        }
                        this.cancel();
                    }
                    catch (Throwable ignored) {
                        retryNumber.getAndDecrement();
                        if (retryNumber.get() >= 1) break block3;
                        this.cancel();
                    }
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(handyRunnable, 60L, 1200L);
    }

    public static void setItemName() {
        HandySchedulerUtil.runTaskLaterAsynchronously(() -> {
            try {
                Map<String, String> itemJsonCacheMap = BaseConstants.ITEM_JSON_CACHE_MAP;
                if (itemJsonCacheMap.isEmpty()) {
                    return;
                }
                itemJsonCacheMap.put("version", BaseConstants.VERSION_CHECK_ENUM.getVersion());
                HttpUtil.post(BaseConstants.CLOUD_SET_URL, JsonUtil.toJson(itemJsonCacheMap));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 1200L);
    }

    public static String getIp() {
        try {
            return HttpUtil.get(BaseConstants.IP_CHINA_URL);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }
}

