/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener;

import com.handy.playertask.constants.BaseTaskConstants;
import com.handy.playertask.lib.annotation.HandyListener;
import com.handy.playertask.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertask.service.TaskCoinService;
import java.util.Date;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;

@HandyListener
public class PlayerQuitEventListener
implements Listener {
    @EventHandler
    public void onKick(PlayerKickEvent event) {
        this.removeCache(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.removeCache(event.getPlayer());
    }

    private void removeCache(Player player) {
        BaseTaskConstants.TASK_LIST_MAP.remove(player.getUniqueId());
        BaseTaskConstants.MYTHIC_MOBS_MAP.remove(player.getUniqueId());
        HandySchedulerUtil.runTaskAsynchronously(() -> TaskCoinService.getInstance().updateLastQuitTimeByPlayer(player.getUniqueId(), new Date()));
    }
}

